package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  WorkGroupDescriptionString,
  WorkGroupName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateWorkGroupRequest(
    name: WorkGroupName,
    configuration: Option[zio.aws.athena.model.WorkGroupConfiguration] = None,
    description: Option[WorkGroupDescriptionString] = None,
    tags: Option[Iterable[zio.aws.athena.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.CreateWorkGroupRequest = {
    import CreateWorkGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.CreateWorkGroupRequest
      .builder()
      .name(WorkGroupName.unwrap(name): java.lang.String)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        description.map(value =>
          WorkGroupDescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.CreateWorkGroupRequest.ReadOnly =
    zio.aws.athena.model.CreateWorkGroupRequest.wrap(buildAwsValue())
}
object CreateWorkGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.CreateWorkGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.CreateWorkGroupRequest =
      zio.aws.athena.model.CreateWorkGroupRequest(
        name,
        configuration.map(value => value.asEditable),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: WorkGroupName
    def configuration
        : Option[zio.aws.athena.model.WorkGroupConfiguration.ReadOnly]
    def description: Option[WorkGroupDescriptionString]
    def tags: Option[List[zio.aws.athena.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, WorkGroupName] = ZIO.succeed(name)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.WorkGroupConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getDescription: ZIO[Any, AwsError, WorkGroupDescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.athena.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.CreateWorkGroupRequest
  ) extends zio.aws.athena.model.CreateWorkGroupRequest.ReadOnly {
    override val name: WorkGroupName =
      zio.aws.athena.model.primitives.WorkGroupName(impl.name())
    override val configuration
        : Option[zio.aws.athena.model.WorkGroupConfiguration.ReadOnly] = scala
      .Option(impl.configuration())
      .map(value => zio.aws.athena.model.WorkGroupConfiguration.wrap(value))
    override val description: Option[WorkGroupDescriptionString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.athena.model.primitives.WorkGroupDescriptionString(value)
      )
    override val tags: Option[List[zio.aws.athena.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.athena.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.CreateWorkGroupRequest
  ): zio.aws.athena.model.CreateWorkGroupRequest.ReadOnly = new Wrapper(impl)
}
