package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  Timestamp,
  KeyString,
  ParametersMapValue,
  NameString,
  TableTypeString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class TableMetadata(
    name: NameString,
    createTime: Option[Timestamp] = None,
    lastAccessTime: Option[Timestamp] = None,
    tableType: Option[TableTypeString] = None,
    columns: Option[Iterable[zio.aws.athena.model.Column]] = None,
    partitionKeys: Option[Iterable[zio.aws.athena.model.Column]] = None,
    parameters: Option[Map[KeyString, ParametersMapValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.TableMetadata = {
    import TableMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.TableMetadata
      .builder()
      .name(NameString.unwrap(name): java.lang.String)
      .optionallyWith(
        createTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createTime)
      .optionallyWith(
        lastAccessTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastAccessTime)
      .optionallyWith(
        tableType.map(value => TableTypeString.unwrap(value): java.lang.String)
      )(_.tableType)
      .optionallyWith(
        columns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.columns)
      .optionallyWith(
        partitionKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.partitionKeys)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (KeyString.unwrap(key): java.lang.String) -> (ParametersMapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.TableMetadata.ReadOnly =
    zio.aws.athena.model.TableMetadata.wrap(buildAwsValue())
}
object TableMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.TableMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.TableMetadata =
      zio.aws.athena.model.TableMetadata(
        name,
        createTime.map(value => value),
        lastAccessTime.map(value => value),
        tableType.map(value => value),
        columns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        partitionKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        parameters.map(value => value)
      )
    def name: NameString
    def createTime: Option[Timestamp]
    def lastAccessTime: Option[Timestamp]
    def tableType: Option[TableTypeString]
    def columns: Option[List[zio.aws.athena.model.Column.ReadOnly]]
    def partitionKeys: Option[List[zio.aws.athena.model.Column.ReadOnly]]
    def parameters: Option[Map[KeyString, ParametersMapValue]]
    def getName: ZIO[Any, Nothing, NameString] = ZIO.succeed(name)
    def getCreateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getLastAccessTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastAccessTime", lastAccessTime)
    def getTableType: ZIO[Any, AwsError, TableTypeString] =
      AwsError.unwrapOptionField("tableType", tableType)
    def getColumns
        : ZIO[Any, AwsError, List[zio.aws.athena.model.Column.ReadOnly]] =
      AwsError.unwrapOptionField("columns", columns)
    def getPartitionKeys
        : ZIO[Any, AwsError, List[zio.aws.athena.model.Column.ReadOnly]] =
      AwsError.unwrapOptionField("partitionKeys", partitionKeys)
    def getParameters: ZIO[Any, AwsError, Map[KeyString, ParametersMapValue]] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.TableMetadata
  ) extends zio.aws.athena.model.TableMetadata.ReadOnly {
    override val name: NameString =
      zio.aws.athena.model.primitives.NameString(impl.name())
    override val createTime: Option[Timestamp] = scala
      .Option(impl.createTime())
      .map(value => zio.aws.athena.model.primitives.Timestamp(value))
    override val lastAccessTime: Option[Timestamp] = scala
      .Option(impl.lastAccessTime())
      .map(value => zio.aws.athena.model.primitives.Timestamp(value))
    override val tableType: Option[TableTypeString] = scala
      .Option(impl.tableType())
      .map(value => zio.aws.athena.model.primitives.TableTypeString(value))
    override val columns: Option[List[zio.aws.athena.model.Column.ReadOnly]] =
      scala
        .Option(impl.columns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.athena.model.Column.wrap(item)
          }.toList
        )
    override val partitionKeys
        : Option[List[zio.aws.athena.model.Column.ReadOnly]] = scala
      .Option(impl.partitionKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.athena.model.Column.wrap(item)
        }.toList
      )
    override val parameters: Option[Map[KeyString, ParametersMapValue]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.athena.model.primitives.KeyString(
              key
            ) -> zio.aws.athena.model.primitives.ParametersMapValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.TableMetadata
  ): zio.aws.athena.model.TableMetadata.ReadOnly = new Wrapper(impl)
}
