package zio.aws.athena.model
import scala.jdk.CollectionConverters.*
sealed trait DataCatalogType {
  def unwrap: software.amazon.awssdk.services.athena.model.DataCatalogType
}
object DataCatalogType {
  def wrap(
      value: software.amazon.awssdk.services.athena.model.DataCatalogType
  ): zio.aws.athena.model.DataCatalogType = value match {
    case software.amazon.awssdk.services.athena.model.DataCatalogType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.athena.model.DataCatalogType.LAMBDA =>
      val r = LAMBDA
      r
    case software.amazon.awssdk.services.athena.model.DataCatalogType.GLUE =>
      val r = GLUE
      r
    case software.amazon.awssdk.services.athena.model.DataCatalogType.HIVE =>
      val r = HIVE
      r
  }
  case object unknownToSdkVersion extends zio.aws.athena.model.DataCatalogType {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.DataCatalogType =
      software.amazon.awssdk.services.athena.model.DataCatalogType.UNKNOWN_TO_SDK_VERSION
  }
  case object LAMBDA extends zio.aws.athena.model.DataCatalogType {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.DataCatalogType =
      software.amazon.awssdk.services.athena.model.DataCatalogType.LAMBDA
  }
  case object GLUE extends zio.aws.athena.model.DataCatalogType {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.DataCatalogType =
      software.amazon.awssdk.services.athena.model.DataCatalogType.GLUE
  }
  case object HIVE extends zio.aws.athena.model.DataCatalogType {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.DataCatalogType =
      software.amazon.awssdk.services.athena.model.DataCatalogType.HIVE
  }
}
