package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  WorkGroupDescriptionString,
  WorkGroupName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateWorkGroupRequest(
    workGroup: WorkGroupName,
    description: Option[WorkGroupDescriptionString] = None,
    configurationUpdates: Option[
      zio.aws.athena.model.WorkGroupConfigurationUpdates
    ] = None,
    state: Option[zio.aws.athena.model.WorkGroupState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.UpdateWorkGroupRequest = {
    import UpdateWorkGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.UpdateWorkGroupRequest
      .builder()
      .workGroup(WorkGroupName.unwrap(workGroup): java.lang.String)
      .optionallyWith(
        description.map(value =>
          WorkGroupDescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(configurationUpdates.map(value => value.buildAwsValue()))(
        _.configurationUpdates
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.UpdateWorkGroupRequest.ReadOnly =
    zio.aws.athena.model.UpdateWorkGroupRequest.wrap(buildAwsValue())
}
object UpdateWorkGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.UpdateWorkGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.UpdateWorkGroupRequest =
      zio.aws.athena.model.UpdateWorkGroupRequest(
        workGroup,
        description.map(value => value),
        configurationUpdates.map(value => value.asEditable),
        state.map(value => value)
      )
    def workGroup: WorkGroupName
    def description: Option[WorkGroupDescriptionString]
    def configurationUpdates
        : Option[zio.aws.athena.model.WorkGroupConfigurationUpdates.ReadOnly]
    def state: Option[zio.aws.athena.model.WorkGroupState]
    def getWorkGroup: ZIO[Any, Nothing, WorkGroupName] = ZIO.succeed(workGroup)
    def getDescription: ZIO[Any, AwsError, WorkGroupDescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getConfigurationUpdates: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.WorkGroupConfigurationUpdates.ReadOnly
    ] = AwsError.unwrapOptionField("configurationUpdates", configurationUpdates)
    def getState: ZIO[Any, AwsError, zio.aws.athena.model.WorkGroupState] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.UpdateWorkGroupRequest
  ) extends zio.aws.athena.model.UpdateWorkGroupRequest.ReadOnly {
    override val workGroup: WorkGroupName =
      zio.aws.athena.model.primitives.WorkGroupName(impl.workGroup())
    override val description: Option[WorkGroupDescriptionString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.athena.model.primitives.WorkGroupDescriptionString(value)
      )
    override val configurationUpdates
        : Option[zio.aws.athena.model.WorkGroupConfigurationUpdates.ReadOnly] =
      scala
        .Option(impl.configurationUpdates())
        .map(value =>
          zio.aws.athena.model.WorkGroupConfigurationUpdates.wrap(value)
        )
    override val state: Option[zio.aws.athena.model.WorkGroupState] = scala
      .Option(impl.state())
      .map(value => zio.aws.athena.model.WorkGroupState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.UpdateWorkGroupRequest
  ): zio.aws.athena.model.UpdateWorkGroupRequest.ReadOnly = new Wrapper(impl)
}
