package zio.aws.athena.model
import java.lang.Integer
import zio.aws.athena.model.primitives.{
  WorkGroupName,
  MaxQueryExecutionsCount,
  Token
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListQueryExecutionsRequest(
    nextToken: Option[Token] = None,
    maxResults: Option[MaxQueryExecutionsCount] = None,
    workGroup: Option[WorkGroupName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest = {
    import ListQueryExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxQueryExecutionsCount.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        workGroup.map(value => WorkGroupName.unwrap(value): java.lang.String)
      )(_.workGroup)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListQueryExecutionsRequest.ReadOnly =
    zio.aws.athena.model.ListQueryExecutionsRequest.wrap(buildAwsValue())
}
object ListQueryExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListQueryExecutionsRequest =
      zio.aws.athena.model.ListQueryExecutionsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        workGroup.map(value => value)
      )
    def nextToken: Option[Token]
    def maxResults: Option[MaxQueryExecutionsCount]
    def workGroup: Option[WorkGroupName]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxQueryExecutionsCount] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getWorkGroup: ZIO[Any, AwsError, WorkGroupName] =
      AwsError.unwrapOptionField("workGroup", workGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest
  ) extends zio.aws.athena.model.ListQueryExecutionsRequest.ReadOnly {
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
    override val maxResults: Option[MaxQueryExecutionsCount] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.athena.model.primitives.MaxQueryExecutionsCount(value)
      )
    override val workGroup: Option[WorkGroupName] = scala
      .Option(impl.workGroup())
      .map(value => zio.aws.athena.model.primitives.WorkGroupName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest
  ): zio.aws.athena.model.ListQueryExecutionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
