package zio.aws.athena.model
import zio.aws.athena.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDataCatalogsResponse(
    dataCatalogsSummary: Option[
      Iterable[zio.aws.athena.model.DataCatalogSummary]
    ] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListDataCatalogsResponse = {
    import ListDataCatalogsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListDataCatalogsResponse
      .builder()
      .optionallyWith(
        dataCatalogsSummary.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataCatalogsSummary)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListDataCatalogsResponse.ReadOnly =
    zio.aws.athena.model.ListDataCatalogsResponse.wrap(buildAwsValue())
}
object ListDataCatalogsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListDataCatalogsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListDataCatalogsResponse =
      zio.aws.athena.model.ListDataCatalogsResponse(
        dataCatalogsSummary.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def dataCatalogsSummary
        : Option[List[zio.aws.athena.model.DataCatalogSummary.ReadOnly]]
    def nextToken: Option[Token]
    def getDataCatalogsSummary: ZIO[Any, AwsError, List[
      zio.aws.athena.model.DataCatalogSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("dataCatalogsSummary", dataCatalogsSummary)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListDataCatalogsResponse
  ) extends zio.aws.athena.model.ListDataCatalogsResponse.ReadOnly {
    override val dataCatalogsSummary
        : Option[List[zio.aws.athena.model.DataCatalogSummary.ReadOnly]] = scala
      .Option(impl.dataCatalogsSummary())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.athena.model.DataCatalogSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListDataCatalogsResponse
  ): zio.aws.athena.model.ListDataCatalogsResponse.ReadOnly = new Wrapper(impl)
}
