package zio.aws.athena.model
import zio.aws.athena.model.primitives.DatumString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Datum(varCharValue: Option[DatumString] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.athena.model.Datum = {
    import Datum.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.Datum
      .builder()
      .optionallyWith(
        varCharValue.map(value => DatumString.unwrap(value): java.lang.String)
      )(_.varCharValue)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.Datum.ReadOnly =
    zio.aws.athena.model.Datum.wrap(buildAwsValue())
}
object Datum {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.athena.model.Datum] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.Datum =
      zio.aws.athena.model.Datum(varCharValue.map(value => value))
    def varCharValue: Option[DatumString]
    def getVarCharValue: ZIO[Any, AwsError, DatumString] =
      AwsError.unwrapOptionField("varCharValue", varCharValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.Datum
  ) extends zio.aws.athena.model.Datum.ReadOnly {
    override val varCharValue: Option[DatumString] = scala
      .Option(impl.varCharValue())
      .map(value => zio.aws.athena.model.primitives.DatumString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.Datum
  ): zio.aws.athena.model.Datum.ReadOnly = new Wrapper(impl)
}
