package zio.aws.athena.model
import zio.aws.athena.model.primitives.{ErrorMessage, ErrorCode, NamedQueryId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UnprocessedNamedQueryId(
    namedQueryId: Option[NamedQueryId] = None,
    errorCode: Option[ErrorCode] = None,
    errorMessage: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.UnprocessedNamedQueryId = {
    import UnprocessedNamedQueryId.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.UnprocessedNamedQueryId
      .builder()
      .optionallyWith(
        namedQueryId.map(value => NamedQueryId.unwrap(value): java.lang.String)
      )(_.namedQueryId)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.UnprocessedNamedQueryId.ReadOnly =
    zio.aws.athena.model.UnprocessedNamedQueryId.wrap(buildAwsValue())
}
object UnprocessedNamedQueryId {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.UnprocessedNamedQueryId
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.UnprocessedNamedQueryId =
      zio.aws.athena.model.UnprocessedNamedQueryId(
        namedQueryId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def namedQueryId: Option[NamedQueryId]
    def errorCode: Option[ErrorCode]
    def errorMessage: Option[ErrorMessage]
    def getNamedQueryId: ZIO[Any, AwsError, NamedQueryId] =
      AwsError.unwrapOptionField("namedQueryId", namedQueryId)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.UnprocessedNamedQueryId
  ) extends zio.aws.athena.model.UnprocessedNamedQueryId.ReadOnly {
    override val namedQueryId: Option[NamedQueryId] = scala
      .Option(impl.namedQueryId())
      .map(value => zio.aws.athena.model.primitives.NamedQueryId(value))
    override val errorCode: Option[ErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.athena.model.primitives.ErrorCode(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.athena.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.UnprocessedNamedQueryId
  ): zio.aws.athena.model.UnprocessedNamedQueryId.ReadOnly = new Wrapper(impl)
}
