package zio.aws.athena.model
import zio.aws.athena.model.primitives.BoxedBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResultConfigurationUpdates(
    outputLocation: Option[String] = None,
    removeOutputLocation: Option[BoxedBoolean] = None,
    encryptionConfiguration: Option[
      zio.aws.athena.model.EncryptionConfiguration
    ] = None,
    removeEncryptionConfiguration: Option[BoxedBoolean] = None,
    expectedBucketOwner: Option[String] = None,
    removeExpectedBucketOwner: Option[BoxedBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ResultConfigurationUpdates = {
    import ResultConfigurationUpdates.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ResultConfigurationUpdates
      .builder()
      .optionallyWith(outputLocation.map(value => value: java.lang.String))(
        _.outputLocation
      )
      .optionallyWith(
        removeOutputLocation.map(value =>
          BoxedBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.removeOutputLocation)
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .optionallyWith(
        removeEncryptionConfiguration.map(value =>
          BoxedBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.removeEncryptionConfiguration)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .optionallyWith(
        removeExpectedBucketOwner.map(value =>
          BoxedBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.removeExpectedBucketOwner)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ResultConfigurationUpdates.ReadOnly =
    zio.aws.athena.model.ResultConfigurationUpdates.wrap(buildAwsValue())
}
object ResultConfigurationUpdates {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ResultConfigurationUpdates
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ResultConfigurationUpdates =
      zio.aws.athena.model.ResultConfigurationUpdates(
        outputLocation.map(value => value),
        removeOutputLocation.map(value => value),
        encryptionConfiguration.map(value => value.asEditable),
        removeEncryptionConfiguration.map(value => value),
        expectedBucketOwner.map(value => value),
        removeExpectedBucketOwner.map(value => value)
      )
    def outputLocation: Option[String]
    def removeOutputLocation: Option[BoxedBoolean]
    def encryptionConfiguration
        : Option[zio.aws.athena.model.EncryptionConfiguration.ReadOnly]
    def removeEncryptionConfiguration: Option[BoxedBoolean]
    def expectedBucketOwner: Option[String]
    def removeExpectedBucketOwner: Option[BoxedBoolean]
    def getOutputLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outputLocation", outputLocation)
    def getRemoveOutputLocation: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("removeOutputLocation", removeOutputLocation)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.EncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
    def getRemoveEncryptionConfiguration: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField(
        "removeEncryptionConfiguration",
        removeEncryptionConfiguration
      )
    def getExpectedBucketOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("expectedBucketOwner", expectedBucketOwner)
    def getRemoveExpectedBucketOwner: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField(
        "removeExpectedBucketOwner",
        removeExpectedBucketOwner
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ResultConfigurationUpdates
  ) extends zio.aws.athena.model.ResultConfigurationUpdates.ReadOnly {
    override val outputLocation: Option[String] =
      scala.Option(impl.outputLocation()).map(value => value: String)
    override val removeOutputLocation: Option[BoxedBoolean] = scala
      .Option(impl.removeOutputLocation())
      .map(value => zio.aws.athena.model.primitives.BoxedBoolean(value))
    override val encryptionConfiguration
        : Option[zio.aws.athena.model.EncryptionConfiguration.ReadOnly] = scala
      .Option(impl.encryptionConfiguration())
      .map(value => zio.aws.athena.model.EncryptionConfiguration.wrap(value))
    override val removeEncryptionConfiguration: Option[BoxedBoolean] = scala
      .Option(impl.removeEncryptionConfiguration())
      .map(value => zio.aws.athena.model.primitives.BoxedBoolean(value))
    override val expectedBucketOwner: Option[String] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: String)
    override val removeExpectedBucketOwner: Option[BoxedBoolean] = scala
      .Option(impl.removeExpectedBucketOwner())
      .map(value => zio.aws.athena.model.primitives.BoxedBoolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ResultConfigurationUpdates
  ): zio.aws.athena.model.ResultConfigurationUpdates.ReadOnly = new Wrapper(
    impl
  )
}
