package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  DatabaseString,
  WorkGroupName,
  NamedQueryId,
  NameString,
  DescriptionString,
  QueryString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class NamedQuery(
    name: NameString,
    description: Option[DescriptionString] = None,
    database: DatabaseString,
    queryString: QueryString,
    namedQueryId: Option[NamedQueryId] = None,
    workGroup: Option[WorkGroupName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.NamedQuery = {
    import NamedQuery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.NamedQuery
      .builder()
      .name(NameString.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .database(DatabaseString.unwrap(database): java.lang.String)
      .queryString(QueryString.unwrap(queryString): java.lang.String)
      .optionallyWith(
        namedQueryId.map(value => NamedQueryId.unwrap(value): java.lang.String)
      )(_.namedQueryId)
      .optionallyWith(
        workGroup.map(value => WorkGroupName.unwrap(value): java.lang.String)
      )(_.workGroup)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.NamedQuery.ReadOnly =
    zio.aws.athena.model.NamedQuery.wrap(buildAwsValue())
}
object NamedQuery {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.athena.model.NamedQuery] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.NamedQuery =
      zio.aws.athena.model.NamedQuery(
        name,
        description.map(value => value),
        database,
        queryString,
        namedQueryId.map(value => value),
        workGroup.map(value => value)
      )
    def name: NameString
    def description: Option[DescriptionString]
    def database: DatabaseString
    def queryString: QueryString
    def namedQueryId: Option[NamedQueryId]
    def workGroup: Option[WorkGroupName]
    def getName: ZIO[Any, Nothing, NameString] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getDatabase: ZIO[Any, Nothing, DatabaseString] = ZIO.succeed(database)
    def getQueryString: ZIO[Any, Nothing, QueryString] =
      ZIO.succeed(queryString)
    def getNamedQueryId: ZIO[Any, AwsError, NamedQueryId] =
      AwsError.unwrapOptionField("namedQueryId", namedQueryId)
    def getWorkGroup: ZIO[Any, AwsError, WorkGroupName] =
      AwsError.unwrapOptionField("workGroup", workGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.NamedQuery
  ) extends zio.aws.athena.model.NamedQuery.ReadOnly {
    override val name: NameString =
      zio.aws.athena.model.primitives.NameString(impl.name())
    override val description: Option[DescriptionString] = scala
      .Option(impl.description())
      .map(value => zio.aws.athena.model.primitives.DescriptionString(value))
    override val database: DatabaseString =
      zio.aws.athena.model.primitives.DatabaseString(impl.database())
    override val queryString: QueryString =
      zio.aws.athena.model.primitives.QueryString(impl.queryString())
    override val namedQueryId: Option[NamedQueryId] = scala
      .Option(impl.namedQueryId())
      .map(value => zio.aws.athena.model.primitives.NamedQueryId(value))
    override val workGroup: Option[WorkGroupName] = scala
      .Option(impl.workGroup())
      .map(value => zio.aws.athena.model.primitives.WorkGroupName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.NamedQuery
  ): zio.aws.athena.model.NamedQuery.ReadOnly = new Wrapper(impl)
}
