package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  ParametersMapValue,
  KeyString,
  DescriptionString,
  CatalogNameString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DataCatalog(
    name: CatalogNameString,
    description: Option[DescriptionString] = None,
    `type`: zio.aws.athena.model.DataCatalogType,
    parameters: Option[Map[KeyString, ParametersMapValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.DataCatalog = {
    import DataCatalog.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.DataCatalog
      .builder()
      .name(CatalogNameString.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          DescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .`type`(`type`.unwrap)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (KeyString.unwrap(key): java.lang.String) -> (ParametersMapValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.DataCatalog.ReadOnly =
    zio.aws.athena.model.DataCatalog.wrap(buildAwsValue())
}
object DataCatalog {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.DataCatalog
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.DataCatalog =
      zio.aws.athena.model.DataCatalog(
        name,
        description.map(value => value),
        `type`,
        parameters.map(value => value)
      )
    def name: CatalogNameString
    def description: Option[DescriptionString]
    def `type`: zio.aws.athena.model.DataCatalogType
    def parameters: Option[Map[KeyString, ParametersMapValue]]
    def getName: ZIO[Any, Nothing, CatalogNameString] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, DescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, Nothing, zio.aws.athena.model.DataCatalogType] =
      ZIO.succeed(`type`)
    def getParameters: ZIO[Any, AwsError, Map[KeyString, ParametersMapValue]] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.DataCatalog
  ) extends zio.aws.athena.model.DataCatalog.ReadOnly {
    override val name: CatalogNameString =
      zio.aws.athena.model.primitives.CatalogNameString(impl.name())
    override val description: Option[DescriptionString] = scala
      .Option(impl.description())
      .map(value => zio.aws.athena.model.primitives.DescriptionString(value))
    override val `type`: zio.aws.athena.model.DataCatalogType =
      zio.aws.athena.model.DataCatalogType.wrap(impl.`type`())
    override val parameters: Option[Map[KeyString, ParametersMapValue]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.athena.model.primitives.KeyString(
              key
            ) -> zio.aws.athena.model.primitives.ParametersMapValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.DataCatalog
  ): zio.aws.athena.model.DataCatalog.ReadOnly = new Wrapper(impl)
}
