package zio.aws.athena
import zio.aws.athena.model.GetQueryExecutionResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.athena.model.{
  CreateWorkGroupRequest,
  GetDataCatalogRequest,
  GetWorkGroupRequest,
  ListWorkGroupsRequest,
  GetNamedQueryRequest,
  DeleteDataCatalogRequest,
  ListTagsForResourceRequest,
  GetDatabaseRequest,
  CreatePreparedStatementRequest,
  DeleteWorkGroupRequest,
  DeletePreparedStatementRequest,
  ListDatabasesRequest,
  ListDataCatalogsRequest,
  GetPreparedStatementRequest,
  ListQueryExecutionsRequest,
  ListPreparedStatementsRequest,
  UpdateWorkGroupRequest,
  BatchGetQueryExecutionRequest,
  StartQueryExecutionRequest,
  ListTableMetadataRequest,
  CreateNamedQueryRequest,
  ListEngineVersionsRequest,
  CreateDataCatalogRequest,
  UntagResourceRequest,
  GetQueryResultsRequest,
  GetTableMetadataRequest,
  UpdateDataCatalogRequest,
  DeleteNamedQueryRequest,
  UpdatePreparedStatementRequest,
  ListNamedQueriesRequest,
  GetQueryExecutionRequest,
  StopQueryExecutionRequest,
  BatchGetNamedQueryRequest,
  TagResourceRequest
}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.athena.AthenaAsyncClient
import zio.aws.athena.model.primitives.{NamedQueryId, QueryExecutionId}
import zio.stream.ZStream
object AthenaMock extends Mock[Athena] {
  object ListDatabases
      extends Stream[
        ListDatabasesRequest,
        AwsError,
        zio.aws.athena.model.Database.ReadOnly
      ]
  object ListDatabasesPaginated
      extends Effect[
        ListDatabasesRequest,
        AwsError,
        zio.aws.athena.model.ListDatabasesResponse.ReadOnly
      ]
  object UpdateDataCatalog
      extends Effect[
        UpdateDataCatalogRequest,
        AwsError,
        zio.aws.athena.model.UpdateDataCatalogResponse.ReadOnly
      ]
  object UpdateWorkGroup
      extends Effect[
        UpdateWorkGroupRequest,
        AwsError,
        zio.aws.athena.model.UpdateWorkGroupResponse.ReadOnly
      ]
  object GetPreparedStatement
      extends Effect[
        GetPreparedStatementRequest,
        AwsError,
        zio.aws.athena.model.GetPreparedStatementResponse.ReadOnly
      ]
  object ListQueryExecutions
      extends Stream[ListQueryExecutionsRequest, AwsError, QueryExecutionId]
  object ListQueryExecutionsPaginated
      extends Effect[
        ListQueryExecutionsRequest,
        AwsError,
        zio.aws.athena.model.ListQueryExecutionsResponse.ReadOnly
      ]
  object ListDataCatalogs
      extends Stream[
        ListDataCatalogsRequest,
        AwsError,
        zio.aws.athena.model.DataCatalogSummary.ReadOnly
      ]
  object ListDataCatalogsPaginated
      extends Effect[
        ListDataCatalogsRequest,
        AwsError,
        zio.aws.athena.model.ListDataCatalogsResponse.ReadOnly
      ]
  object GetNamedQuery
      extends Effect[
        GetNamedQueryRequest,
        AwsError,
        zio.aws.athena.model.GetNamedQueryResponse.ReadOnly
      ]
  object DeletePreparedStatement
      extends Effect[
        DeletePreparedStatementRequest,
        AwsError,
        zio.aws.athena.model.DeletePreparedStatementResponse.ReadOnly
      ]
  object ListEngineVersions
      extends Stream[
        ListEngineVersionsRequest,
        AwsError,
        zio.aws.athena.model.EngineVersion.ReadOnly
      ]
  object ListEngineVersionsPaginated
      extends Effect[
        ListEngineVersionsRequest,
        AwsError,
        zio.aws.athena.model.ListEngineVersionsResponse.ReadOnly
      ]
  object DeleteNamedQuery
      extends Effect[
        DeleteNamedQueryRequest,
        AwsError,
        zio.aws.athena.model.DeleteNamedQueryResponse.ReadOnly
      ]
  object GetTableMetadata
      extends Effect[
        GetTableMetadataRequest,
        AwsError,
        zio.aws.athena.model.GetTableMetadataResponse.ReadOnly
      ]
  object BatchGetNamedQuery
      extends Effect[
        BatchGetNamedQueryRequest,
        AwsError,
        zio.aws.athena.model.BatchGetNamedQueryResponse.ReadOnly
      ]
  object CreateNamedQuery
      extends Effect[
        CreateNamedQueryRequest,
        AwsError,
        zio.aws.athena.model.CreateNamedQueryResponse.ReadOnly
      ]
  object GetDataCatalog
      extends Effect[
        GetDataCatalogRequest,
        AwsError,
        zio.aws.athena.model.GetDataCatalogResponse.ReadOnly
      ]
  object ListWorkGroups
      extends Stream[
        ListWorkGroupsRequest,
        AwsError,
        zio.aws.athena.model.WorkGroupSummary.ReadOnly
      ]
  object ListWorkGroupsPaginated
      extends Effect[
        ListWorkGroupsRequest,
        AwsError,
        zio.aws.athena.model.ListWorkGroupsResponse.ReadOnly
      ]
  object ListPreparedStatements
      extends Stream[
        ListPreparedStatementsRequest,
        AwsError,
        zio.aws.athena.model.PreparedStatementSummary.ReadOnly
      ]
  object ListPreparedStatementsPaginated
      extends Effect[
        ListPreparedStatementsRequest,
        AwsError,
        zio.aws.athena.model.ListPreparedStatementsResponse.ReadOnly
      ]
  object CreatePreparedStatement
      extends Effect[
        CreatePreparedStatementRequest,
        AwsError,
        zio.aws.athena.model.CreatePreparedStatementResponse.ReadOnly
      ]
  object DeleteDataCatalog
      extends Effect[
        DeleteDataCatalogRequest,
        AwsError,
        zio.aws.athena.model.DeleteDataCatalogResponse.ReadOnly
      ]
  object GetQueryExecution
      extends Effect[GetQueryExecutionRequest, AwsError, ReadOnly]
  object UpdatePreparedStatement
      extends Effect[
        UpdatePreparedStatementRequest,
        AwsError,
        zio.aws.athena.model.UpdatePreparedStatementResponse.ReadOnly
      ]
  object CreateDataCatalog
      extends Effect[
        CreateDataCatalogRequest,
        AwsError,
        zio.aws.athena.model.CreateDataCatalogResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.athena.model.UntagResourceResponse.ReadOnly
      ]
  object ListTableMetadata
      extends Stream[
        ListTableMetadataRequest,
        AwsError,
        zio.aws.athena.model.TableMetadata.ReadOnly
      ]
  object ListTableMetadataPaginated
      extends Effect[
        ListTableMetadataRequest,
        AwsError,
        zio.aws.athena.model.ListTableMetadataResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Stream[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.athena.model.Tag.ReadOnly
      ]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.athena.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.athena.model.TagResourceResponse.ReadOnly
      ]
  object ListNamedQueries
      extends Stream[ListNamedQueriesRequest, AwsError, NamedQueryId]
  object ListNamedQueriesPaginated
      extends Effect[
        ListNamedQueriesRequest,
        AwsError,
        zio.aws.athena.model.ListNamedQueriesResponse.ReadOnly
      ]
  object DeleteWorkGroup
      extends Effect[
        DeleteWorkGroupRequest,
        AwsError,
        zio.aws.athena.model.DeleteWorkGroupResponse.ReadOnly
      ]
  object GetDatabase
      extends Effect[
        GetDatabaseRequest,
        AwsError,
        zio.aws.athena.model.GetDatabaseResponse.ReadOnly
      ]
  object CreateWorkGroup
      extends Effect[
        CreateWorkGroupRequest,
        AwsError,
        zio.aws.athena.model.CreateWorkGroupResponse.ReadOnly
      ]
  object GetWorkGroup
      extends Effect[
        GetWorkGroupRequest,
        AwsError,
        zio.aws.athena.model.GetWorkGroupResponse.ReadOnly
      ]
  object BatchGetQueryExecution
      extends Effect[
        BatchGetQueryExecutionRequest,
        AwsError,
        zio.aws.athena.model.BatchGetQueryExecutionResponse.ReadOnly
      ]
  object StartQueryExecution
      extends Effect[
        StartQueryExecutionRequest,
        AwsError,
        zio.aws.athena.model.StartQueryExecutionResponse.ReadOnly
      ]
  object GetQueryResults
      extends Effect[GetQueryResultsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.athena.model.ResultSetMetadata.ReadOnly,
        zio.aws.athena.model.Row.ReadOnly
      ]]
  object GetQueryResultsPaginated
      extends Effect[
        GetQueryResultsRequest,
        AwsError,
        zio.aws.athena.model.GetQueryResultsResponse.ReadOnly
      ]
  object StopQueryExecution
      extends Effect[
        StopQueryExecutionRequest,
        AwsError,
        zio.aws.athena.model.StopQueryExecutionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Athena] = ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Athena {
          val api: AthenaAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Athena = this
          def listDatabases(
              request: ListDatabasesRequest
          ): ZStream[Any, AwsError, zio.aws.athena.model.Database.ReadOnly] =
            rts.unsafeRun(proxy(ListDatabases, request))
          def listDatabasesPaginated(
              request: ListDatabasesRequest
          ): IO[AwsError, zio.aws.athena.model.ListDatabasesResponse.ReadOnly] =
            proxy(ListDatabasesPaginated, request)
          def updateDataCatalog(request: UpdateDataCatalogRequest): IO[
            AwsError,
            zio.aws.athena.model.UpdateDataCatalogResponse.ReadOnly
          ] = proxy(UpdateDataCatalog, request)
          def updateWorkGroup(request: UpdateWorkGroupRequest): IO[
            AwsError,
            zio.aws.athena.model.UpdateWorkGroupResponse.ReadOnly
          ] = proxy(UpdateWorkGroup, request)
          def getPreparedStatement(request: GetPreparedStatementRequest): IO[
            AwsError,
            zio.aws.athena.model.GetPreparedStatementResponse.ReadOnly
          ] = proxy(GetPreparedStatement, request)
          def listQueryExecutions(
              request: ListQueryExecutionsRequest
          ): ZStream[Any, AwsError, QueryExecutionId] =
            rts.unsafeRun(proxy(ListQueryExecutions, request))
          def listQueryExecutionsPaginated(
              request: ListQueryExecutionsRequest
          ): IO[
            AwsError,
            zio.aws.athena.model.ListQueryExecutionsResponse.ReadOnly
          ] = proxy(ListQueryExecutionsPaginated, request)
          def listDataCatalogs(request: ListDataCatalogsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.athena.model.DataCatalogSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListDataCatalogs, request))
          def listDataCatalogsPaginated(request: ListDataCatalogsRequest): IO[
            AwsError,
            zio.aws.athena.model.ListDataCatalogsResponse.ReadOnly
          ] = proxy(ListDataCatalogsPaginated, request)
          def getNamedQuery(
              request: GetNamedQueryRequest
          ): IO[AwsError, zio.aws.athena.model.GetNamedQueryResponse.ReadOnly] =
            proxy(GetNamedQuery, request)
          def deletePreparedStatement(
              request: DeletePreparedStatementRequest
          ): IO[
            AwsError,
            zio.aws.athena.model.DeletePreparedStatementResponse.ReadOnly
          ] = proxy(DeletePreparedStatement, request)
          def listEngineVersions(request: ListEngineVersionsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.athena.model.EngineVersion.ReadOnly
          ] = rts.unsafeRun(proxy(ListEngineVersions, request))
          def listEngineVersionsPaginated(
              request: ListEngineVersionsRequest
          ): IO[
            AwsError,
            zio.aws.athena.model.ListEngineVersionsResponse.ReadOnly
          ] = proxy(ListEngineVersionsPaginated, request)
          def deleteNamedQuery(request: DeleteNamedQueryRequest): IO[
            AwsError,
            zio.aws.athena.model.DeleteNamedQueryResponse.ReadOnly
          ] = proxy(DeleteNamedQuery, request)
          def getTableMetadata(request: GetTableMetadataRequest): IO[
            AwsError,
            zio.aws.athena.model.GetTableMetadataResponse.ReadOnly
          ] = proxy(GetTableMetadata, request)
          def batchGetNamedQuery(request: BatchGetNamedQueryRequest): IO[
            AwsError,
            zio.aws.athena.model.BatchGetNamedQueryResponse.ReadOnly
          ] = proxy(BatchGetNamedQuery, request)
          def createNamedQuery(request: CreateNamedQueryRequest): IO[
            AwsError,
            zio.aws.athena.model.CreateNamedQueryResponse.ReadOnly
          ] = proxy(CreateNamedQuery, request)
          def getDataCatalog(request: GetDataCatalogRequest): IO[
            AwsError,
            zio.aws.athena.model.GetDataCatalogResponse.ReadOnly
          ] = proxy(GetDataCatalog, request)
          def listWorkGroups(request: ListWorkGroupsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.athena.model.WorkGroupSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListWorkGroups, request))
          def listWorkGroupsPaginated(request: ListWorkGroupsRequest): IO[
            AwsError,
            zio.aws.athena.model.ListWorkGroupsResponse.ReadOnly
          ] = proxy(ListWorkGroupsPaginated, request)
          def listPreparedStatements(
              request: ListPreparedStatementsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.athena.model.PreparedStatementSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListPreparedStatements, request))
          def listPreparedStatementsPaginated(
              request: ListPreparedStatementsRequest
          ): IO[
            AwsError,
            zio.aws.athena.model.ListPreparedStatementsResponse.ReadOnly
          ] = proxy(ListPreparedStatementsPaginated, request)
          def createPreparedStatement(
              request: CreatePreparedStatementRequest
          ): IO[
            AwsError,
            zio.aws.athena.model.CreatePreparedStatementResponse.ReadOnly
          ] = proxy(CreatePreparedStatement, request)
          def deleteDataCatalog(request: DeleteDataCatalogRequest): IO[
            AwsError,
            zio.aws.athena.model.DeleteDataCatalogResponse.ReadOnly
          ] = proxy(DeleteDataCatalog, request)
          def getQueryExecution(
              request: GetQueryExecutionRequest
          ): IO[AwsError, ReadOnly] = proxy(GetQueryExecution, request)
          def updatePreparedStatement(
              request: UpdatePreparedStatementRequest
          ): IO[
            AwsError,
            zio.aws.athena.model.UpdatePreparedStatementResponse.ReadOnly
          ] = proxy(UpdatePreparedStatement, request)
          def createDataCatalog(request: CreateDataCatalogRequest): IO[
            AwsError,
            zio.aws.athena.model.CreateDataCatalogResponse.ReadOnly
          ] = proxy(CreateDataCatalog, request)
          def untagResource(
              request: UntagResourceRequest
          ): IO[AwsError, zio.aws.athena.model.UntagResourceResponse.ReadOnly] =
            proxy(UntagResource, request)
          def listTableMetadata(request: ListTableMetadataRequest): ZStream[
            Any,
            AwsError,
            zio.aws.athena.model.TableMetadata.ReadOnly
          ] = rts.unsafeRun(proxy(ListTableMetadata, request))
          def listTableMetadataPaginated(request: ListTableMetadataRequest): IO[
            AwsError,
            zio.aws.athena.model.ListTableMetadataResponse.ReadOnly
          ] = proxy(ListTableMetadataPaginated, request)
          def listTagsForResource(
              request: ListTagsForResourceRequest
          ): ZStream[Any, AwsError, zio.aws.athena.model.Tag.ReadOnly] =
            rts.unsafeRun(proxy(ListTagsForResource, request))
          def listTagsForResourcePaginated(
              request: ListTagsForResourceRequest
          ): IO[
            AwsError,
            zio.aws.athena.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResourcePaginated, request)
          def tagResource(
              request: TagResourceRequest
          ): IO[AwsError, zio.aws.athena.model.TagResourceResponse.ReadOnly] =
            proxy(TagResource, request)
          def listNamedQueries(
              request: ListNamedQueriesRequest
          ): ZStream[Any, AwsError, NamedQueryId] =
            rts.unsafeRun(proxy(ListNamedQueries, request))
          def listNamedQueriesPaginated(request: ListNamedQueriesRequest): IO[
            AwsError,
            zio.aws.athena.model.ListNamedQueriesResponse.ReadOnly
          ] = proxy(ListNamedQueriesPaginated, request)
          def deleteWorkGroup(request: DeleteWorkGroupRequest): IO[
            AwsError,
            zio.aws.athena.model.DeleteWorkGroupResponse.ReadOnly
          ] = proxy(DeleteWorkGroup, request)
          def getDatabase(
              request: GetDatabaseRequest
          ): IO[AwsError, zio.aws.athena.model.GetDatabaseResponse.ReadOnly] =
            proxy(GetDatabase, request)
          def createWorkGroup(request: CreateWorkGroupRequest): IO[
            AwsError,
            zio.aws.athena.model.CreateWorkGroupResponse.ReadOnly
          ] = proxy(CreateWorkGroup, request)
          def getWorkGroup(
              request: GetWorkGroupRequest
          ): IO[AwsError, zio.aws.athena.model.GetWorkGroupResponse.ReadOnly] =
            proxy(GetWorkGroup, request)
          def batchGetQueryExecution(
              request: BatchGetQueryExecutionRequest
          ): IO[
            AwsError,
            zio.aws.athena.model.BatchGetQueryExecutionResponse.ReadOnly
          ] = proxy(BatchGetQueryExecution, request)
          def startQueryExecution(request: StartQueryExecutionRequest): IO[
            AwsError,
            zio.aws.athena.model.StartQueryExecutionResponse.ReadOnly
          ] = proxy(StartQueryExecution, request)
          def getQueryResults(
              request: GetQueryResultsRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.athena.model.ResultSetMetadata.ReadOnly,
            zio.aws.athena.model.Row.ReadOnly
          ]] = proxy(GetQueryResults, request)
          def getQueryResultsPaginated(request: GetQueryResultsRequest): IO[
            AwsError,
            zio.aws.athena.model.GetQueryResultsResponse.ReadOnly
          ] = proxy(GetQueryResultsPaginated, request)
          def stopQueryExecution(request: StopQueryExecutionRequest): IO[
            AwsError,
            zio.aws.athena.model.StopQueryExecutionResponse.ReadOnly
          ] = proxy(StopQueryExecution, request)
        }
      }
    }
    .toLayer
}
