package zio.aws.athena.model
import scala.jdk.CollectionConverters.*
sealed trait StatementType {
  def unwrap: software.amazon.awssdk.services.athena.model.StatementType
}
object StatementType {
  def wrap(
      value: software.amazon.awssdk.services.athena.model.StatementType
  ): zio.aws.athena.model.StatementType = value match {
    case software.amazon.awssdk.services.athena.model.StatementType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.athena.model.StatementType.DDL =>
      val r = DDL
      r
    case software.amazon.awssdk.services.athena.model.StatementType.DML =>
      val r = DML
      r
    case software.amazon.awssdk.services.athena.model.StatementType.UTILITY =>
      val r = UTILITY
      r
  }
  case object unknownToSdkVersion extends zio.aws.athena.model.StatementType {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.StatementType =
      software.amazon.awssdk.services.athena.model.StatementType.UNKNOWN_TO_SDK_VERSION
  }
  case object DDL extends zio.aws.athena.model.StatementType {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.StatementType =
      software.amazon.awssdk.services.athena.model.StatementType.DDL
  }
  case object DML extends zio.aws.athena.model.StatementType {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.StatementType =
      software.amazon.awssdk.services.athena.model.StatementType.DML
  }
  case object UTILITY extends zio.aws.athena.model.StatementType {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.StatementType =
      software.amazon.awssdk.services.athena.model.StatementType.UTILITY
  }
}
