package zio.aws.athena.model
import java.lang.Integer
import zio.aws.athena.model.primitives.{
  WorkGroupName,
  MaxNamedQueriesCount,
  Token
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListNamedQueriesRequest(
    nextToken: Option[Token] = None,
    maxResults: Option[MaxNamedQueriesCount] = None,
    workGroup: Option[WorkGroupName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest = {
    import ListNamedQueriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxNamedQueriesCount.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        workGroup.map(value => WorkGroupName.unwrap(value): java.lang.String)
      )(_.workGroup)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListNamedQueriesRequest.ReadOnly =
    zio.aws.athena.model.ListNamedQueriesRequest.wrap(buildAwsValue())
}
object ListNamedQueriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListNamedQueriesRequest =
      zio.aws.athena.model.ListNamedQueriesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        workGroup.map(value => value)
      )
    def nextToken: Option[Token]
    def maxResults: Option[MaxNamedQueriesCount]
    def workGroup: Option[WorkGroupName]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxNamedQueriesCount] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getWorkGroup: ZIO[Any, AwsError, WorkGroupName] =
      AwsError.unwrapOptionField("workGroup", workGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest
  ) extends zio.aws.athena.model.ListNamedQueriesRequest.ReadOnly {
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
    override val maxResults: Option[MaxNamedQueriesCount] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.athena.model.primitives.MaxNamedQueriesCount(value))
    override val workGroup: Option[WorkGroupName] = scala
      .Option(impl.workGroup())
      .map(value => zio.aws.athena.model.primitives.WorkGroupName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest
  ): zio.aws.athena.model.ListNamedQueriesRequest.ReadOnly = new Wrapper(impl)
}
