package zio.aws.athena.model
import zio.aws.athena.model.primitives.NamedQueryId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteNamedQueryRequest(namedQueryId: NamedQueryId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.DeleteNamedQueryRequest = {
    import DeleteNamedQueryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.DeleteNamedQueryRequest
      .builder()
      .namedQueryId(NamedQueryId.unwrap(namedQueryId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.DeleteNamedQueryRequest.ReadOnly =
    zio.aws.athena.model.DeleteNamedQueryRequest.wrap(buildAwsValue())
}
object DeleteNamedQueryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.DeleteNamedQueryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.DeleteNamedQueryRequest =
      zio.aws.athena.model.DeleteNamedQueryRequest(namedQueryId)
    def namedQueryId: NamedQueryId
    def getNamedQueryId: ZIO[Any, Nothing, NamedQueryId] =
      ZIO.succeed(namedQueryId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.DeleteNamedQueryRequest
  ) extends zio.aws.athena.model.DeleteNamedQueryRequest.ReadOnly {
    override val namedQueryId: NamedQueryId =
      zio.aws.athena.model.primitives.NamedQueryId(impl.namedQueryId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.DeleteNamedQueryRequest
  ): zio.aws.athena.model.DeleteNamedQueryRequest.ReadOnly = new Wrapper(impl)
}
