package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetTableMetadataResponse(
    tableMetadata: Option[zio.aws.athena.model.TableMetadata] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetTableMetadataResponse = {
    import GetTableMetadataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetTableMetadataResponse
      .builder()
      .optionallyWith(tableMetadata.map(value => value.buildAwsValue()))(
        _.tableMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetTableMetadataResponse.ReadOnly =
    zio.aws.athena.model.GetTableMetadataResponse.wrap(buildAwsValue())
}
object GetTableMetadataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetTableMetadataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetTableMetadataResponse =
      zio.aws.athena.model
        .GetTableMetadataResponse(tableMetadata.map(value => value.asEditable))
    def tableMetadata: Option[zio.aws.athena.model.TableMetadata.ReadOnly]
    def getTableMetadata
        : ZIO[Any, AwsError, zio.aws.athena.model.TableMetadata.ReadOnly] =
      AwsError.unwrapOptionField("tableMetadata", tableMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetTableMetadataResponse
  ) extends zio.aws.athena.model.GetTableMetadataResponse.ReadOnly {
    override val tableMetadata
        : Option[zio.aws.athena.model.TableMetadata.ReadOnly] = scala
      .Option(impl.tableMetadata())
      .map(value => zio.aws.athena.model.TableMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetTableMetadataResponse
  ): zio.aws.athena.model.GetTableMetadataResponse.ReadOnly = new Wrapper(impl)
}
