package zio.aws.athena.model
import java.lang.Integer
import zio.aws.athena.model.primitives.ErrorCategory
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AthenaError(errorCategory: Option[ErrorCategory] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.AthenaError = {
    import AthenaError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.AthenaError
      .builder()
      .optionallyWith(
        errorCategory.map(value => ErrorCategory.unwrap(value): Integer)
      )(_.errorCategory)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.AthenaError.ReadOnly =
    zio.aws.athena.model.AthenaError.wrap(buildAwsValue())
}
object AthenaError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.AthenaError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.AthenaError =
      zio.aws.athena.model.AthenaError(errorCategory.map(value => value))
    def errorCategory: Option[ErrorCategory]
    def getErrorCategory: ZIO[Any, AwsError, ErrorCategory] =
      AwsError.unwrapOptionField("errorCategory", errorCategory)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.AthenaError
  ) extends zio.aws.athena.model.AthenaError.ReadOnly {
    override val errorCategory: Option[ErrorCategory] = scala
      .Option(impl.errorCategory())
      .map(value => zio.aws.athena.model.primitives.ErrorCategory(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.AthenaError
  ): zio.aws.athena.model.AthenaError.ReadOnly = new Wrapper(impl)
}
