package zio.aws.athena.model
import zio.aws.athena.model.primitives.{
  WorkGroupName,
  IdempotencyToken,
  QueryString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartQueryExecutionRequest(
    queryString: QueryString,
    clientRequestToken: Option[IdempotencyToken] = None,
    queryExecutionContext: Option[zio.aws.athena.model.QueryExecutionContext] =
      None,
    resultConfiguration: Option[zio.aws.athena.model.ResultConfiguration] =
      None,
    workGroup: Option[WorkGroupName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest = {
    import StartQueryExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest
      .builder()
      .queryString(QueryString.unwrap(queryString): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        queryExecutionContext.map(value => value.buildAwsValue())
      )(_.queryExecutionContext)
      .optionallyWith(resultConfiguration.map(value => value.buildAwsValue()))(
        _.resultConfiguration
      )
      .optionallyWith(
        workGroup.map(value => WorkGroupName.unwrap(value): java.lang.String)
      )(_.workGroup)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.StartQueryExecutionRequest.ReadOnly =
    zio.aws.athena.model.StartQueryExecutionRequest.wrap(buildAwsValue())
}
object StartQueryExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.StartQueryExecutionRequest =
      zio.aws.athena.model.StartQueryExecutionRequest(
        queryString,
        clientRequestToken.map(value => value),
        queryExecutionContext.map(value => value.asEditable),
        resultConfiguration.map(value => value.asEditable),
        workGroup.map(value => value)
      )
    def queryString: QueryString
    def clientRequestToken: Option[IdempotencyToken]
    def queryExecutionContext
        : Option[zio.aws.athena.model.QueryExecutionContext.ReadOnly]
    def resultConfiguration
        : Option[zio.aws.athena.model.ResultConfiguration.ReadOnly]
    def workGroup: Option[WorkGroupName]
    def getQueryString: ZIO[Any, Nothing, QueryString] =
      ZIO.succeed(queryString)
    def getClientRequestToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getQueryExecutionContext: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.QueryExecutionContext.ReadOnly
    ] =
      AwsError.unwrapOptionField("queryExecutionContext", queryExecutionContext)
    def getResultConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.athena.model.ResultConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("resultConfiguration", resultConfiguration)
    def getWorkGroup: ZIO[Any, AwsError, WorkGroupName] =
      AwsError.unwrapOptionField("workGroup", workGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest
  ) extends zio.aws.athena.model.StartQueryExecutionRequest.ReadOnly {
    override val queryString: QueryString =
      zio.aws.athena.model.primitives.QueryString(impl.queryString())
    override val clientRequestToken: Option[IdempotencyToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.athena.model.primitives.IdempotencyToken(value))
    override val queryExecutionContext
        : Option[zio.aws.athena.model.QueryExecutionContext.ReadOnly] = scala
      .Option(impl.queryExecutionContext())
      .map(value => zio.aws.athena.model.QueryExecutionContext.wrap(value))
    override val resultConfiguration
        : Option[zio.aws.athena.model.ResultConfiguration.ReadOnly] = scala
      .Option(impl.resultConfiguration())
      .map(value => zio.aws.athena.model.ResultConfiguration.wrap(value))
    override val workGroup: Option[WorkGroupName] = scala
      .Option(impl.workGroup())
      .map(value => zio.aws.athena.model.primitives.WorkGroupName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.StartQueryExecutionRequest
  ): zio.aws.athena.model.StartQueryExecutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
