package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchGetNamedQueryResponse(
    namedQueries: Option[Iterable[zio.aws.athena.model.NamedQuery]] = None,
    unprocessedNamedQueryIds: Option[
      Iterable[zio.aws.athena.model.UnprocessedNamedQueryId]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.BatchGetNamedQueryResponse = {
    import BatchGetNamedQueryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.BatchGetNamedQueryResponse
      .builder()
      .optionallyWith(
        namedQueries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.namedQueries)
      .optionallyWith(
        unprocessedNamedQueryIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedNamedQueryIds)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.BatchGetNamedQueryResponse.ReadOnly =
    zio.aws.athena.model.BatchGetNamedQueryResponse.wrap(buildAwsValue())
}
object BatchGetNamedQueryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.BatchGetNamedQueryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.BatchGetNamedQueryResponse =
      zio.aws.athena.model.BatchGetNamedQueryResponse(
        namedQueries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unprocessedNamedQueryIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def namedQueries: Option[List[zio.aws.athena.model.NamedQuery.ReadOnly]]
    def unprocessedNamedQueryIds
        : Option[List[zio.aws.athena.model.UnprocessedNamedQueryId.ReadOnly]]
    def getNamedQueries
        : ZIO[Any, AwsError, List[zio.aws.athena.model.NamedQuery.ReadOnly]] =
      AwsError.unwrapOptionField("namedQueries", namedQueries)
    def getUnprocessedNamedQueryIds: ZIO[Any, AwsError, List[
      zio.aws.athena.model.UnprocessedNamedQueryId.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unprocessedNamedQueryIds",
      unprocessedNamedQueryIds
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.BatchGetNamedQueryResponse
  ) extends zio.aws.athena.model.BatchGetNamedQueryResponse.ReadOnly {
    override val namedQueries
        : Option[List[zio.aws.athena.model.NamedQuery.ReadOnly]] = scala
      .Option(impl.namedQueries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.athena.model.NamedQuery.wrap(item)
        }.toList
      )
    override val unprocessedNamedQueryIds
        : Option[List[zio.aws.athena.model.UnprocessedNamedQueryId.ReadOnly]] =
      scala
        .Option(impl.unprocessedNamedQueryIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.athena.model.UnprocessedNamedQueryId.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.BatchGetNamedQueryResponse
  ): zio.aws.athena.model.BatchGetNamedQueryResponse.ReadOnly = new Wrapper(
    impl
  )
}
