package zio.aws.athena.model
import zio.aws.athena.model.primitives.QueryExecutionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartQueryExecutionResponse(
    queryExecutionId: Option[QueryExecutionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.StartQueryExecutionResponse = {
    import StartQueryExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.StartQueryExecutionResponse
      .builder()
      .optionallyWith(
        queryExecutionId.map(value =>
          QueryExecutionId.unwrap(value): java.lang.String
        )
      )(_.queryExecutionId)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.StartQueryExecutionResponse.ReadOnly =
    zio.aws.athena.model.StartQueryExecutionResponse.wrap(buildAwsValue())
}
object StartQueryExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.StartQueryExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.StartQueryExecutionResponse =
      zio.aws.athena.model
        .StartQueryExecutionResponse(queryExecutionId.map(value => value))
    def queryExecutionId: Option[QueryExecutionId]
    def getQueryExecutionId: ZIO[Any, AwsError, QueryExecutionId] =
      AwsError.unwrapOptionField("queryExecutionId", queryExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.StartQueryExecutionResponse
  ) extends zio.aws.athena.model.StartQueryExecutionResponse.ReadOnly {
    override val queryExecutionId: Option[QueryExecutionId] = scala
      .Option(impl.queryExecutionId())
      .map(value => zio.aws.athena.model.primitives.QueryExecutionId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.StartQueryExecutionResponse
  ): zio.aws.athena.model.StartQueryExecutionResponse.ReadOnly = new Wrapper(
    impl
  )
}
