package zio.aws.athena.model
import zio.aws.athena.model.primitives.Date
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class QueryExecutionStatus(
    state: Option[zio.aws.athena.model.QueryExecutionState] = None,
    stateChangeReason: Option[String] = None,
    submissionDateTime: Option[Date] = None,
    completionDateTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.QueryExecutionStatus = {
    import QueryExecutionStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.QueryExecutionStatus
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateChangeReason.map(value => value: java.lang.String))(
        _.stateChangeReason
      )
      .optionallyWith(
        submissionDateTime.map(value => Date.unwrap(value): Instant)
      )(_.submissionDateTime)
      .optionallyWith(
        completionDateTime.map(value => Date.unwrap(value): Instant)
      )(_.completionDateTime)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.QueryExecutionStatus.ReadOnly =
    zio.aws.athena.model.QueryExecutionStatus.wrap(buildAwsValue())
}
object QueryExecutionStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.QueryExecutionStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.QueryExecutionStatus =
      zio.aws.athena.model.QueryExecutionStatus(
        state.map(value => value),
        stateChangeReason.map(value => value),
        submissionDateTime.map(value => value),
        completionDateTime.map(value => value)
      )
    def state: Option[zio.aws.athena.model.QueryExecutionState]
    def stateChangeReason: Option[String]
    def submissionDateTime: Option[Date]
    def completionDateTime: Option[Date]
    def getState: ZIO[Any, AwsError, zio.aws.athena.model.QueryExecutionState] =
      AwsError.unwrapOptionField("state", state)
    def getStateChangeReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stateChangeReason", stateChangeReason)
    def getSubmissionDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("submissionDateTime", submissionDateTime)
    def getCompletionDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("completionDateTime", completionDateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.QueryExecutionStatus
  ) extends zio.aws.athena.model.QueryExecutionStatus.ReadOnly {
    override val state: Option[zio.aws.athena.model.QueryExecutionState] = scala
      .Option(impl.state())
      .map(value => zio.aws.athena.model.QueryExecutionState.wrap(value))
    override val stateChangeReason: Option[String] =
      scala.Option(impl.stateChangeReason()).map(value => value: String)
    override val submissionDateTime: Option[Date] = scala
      .Option(impl.submissionDateTime())
      .map(value => zio.aws.athena.model.primitives.Date(value))
    override val completionDateTime: Option[Date] = scala
      .Option(impl.completionDateTime())
      .map(value => zio.aws.athena.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.QueryExecutionStatus
  ): zio.aws.athena.model.QueryExecutionStatus.ReadOnly = new Wrapper(impl)
}
