package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class QueryExecutionStatistics(
    engineExecutionTimeInMillis: Option[Long] = None,
    dataScannedInBytes: Option[Long] = None,
    dataManifestLocation: Option[String] = None,
    totalExecutionTimeInMillis: Option[Long] = None,
    queryQueueTimeInMillis: Option[Long] = None,
    queryPlanningTimeInMillis: Option[Long] = None,
    serviceProcessingTimeInMillis: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.QueryExecutionStatistics = {
    import QueryExecutionStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.QueryExecutionStatistics
      .builder()
      .optionallyWith(
        engineExecutionTimeInMillis.map(value => value: java.lang.Long)
      )(_.engineExecutionTimeInMillis)
      .optionallyWith(dataScannedInBytes.map(value => value: java.lang.Long))(
        _.dataScannedInBytes
      )
      .optionallyWith(
        dataManifestLocation.map(value => value: java.lang.String)
      )(_.dataManifestLocation)
      .optionallyWith(
        totalExecutionTimeInMillis.map(value => value: java.lang.Long)
      )(_.totalExecutionTimeInMillis)
      .optionallyWith(
        queryQueueTimeInMillis.map(value => value: java.lang.Long)
      )(_.queryQueueTimeInMillis)
      .optionallyWith(
        queryPlanningTimeInMillis.map(value => value: java.lang.Long)
      )(_.queryPlanningTimeInMillis)
      .optionallyWith(
        serviceProcessingTimeInMillis.map(value => value: java.lang.Long)
      )(_.serviceProcessingTimeInMillis)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.QueryExecutionStatistics.ReadOnly =
    zio.aws.athena.model.QueryExecutionStatistics.wrap(buildAwsValue())
}
object QueryExecutionStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.QueryExecutionStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.QueryExecutionStatistics =
      zio.aws.athena.model.QueryExecutionStatistics(
        engineExecutionTimeInMillis.map(value => value),
        dataScannedInBytes.map(value => value),
        dataManifestLocation.map(value => value),
        totalExecutionTimeInMillis.map(value => value),
        queryQueueTimeInMillis.map(value => value),
        queryPlanningTimeInMillis.map(value => value),
        serviceProcessingTimeInMillis.map(value => value)
      )
    def engineExecutionTimeInMillis: Option[Long]
    def dataScannedInBytes: Option[Long]
    def dataManifestLocation: Option[String]
    def totalExecutionTimeInMillis: Option[Long]
    def queryQueueTimeInMillis: Option[Long]
    def queryPlanningTimeInMillis: Option[Long]
    def serviceProcessingTimeInMillis: Option[Long]
    def getEngineExecutionTimeInMillis: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "engineExecutionTimeInMillis",
        engineExecutionTimeInMillis
      )
    def getDataScannedInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("dataScannedInBytes", dataScannedInBytes)
    def getDataManifestLocation: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataManifestLocation", dataManifestLocation)
    def getTotalExecutionTimeInMillis: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "totalExecutionTimeInMillis",
        totalExecutionTimeInMillis
      )
    def getQueryQueueTimeInMillis: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("queryQueueTimeInMillis", queryQueueTimeInMillis)
    def getQueryPlanningTimeInMillis: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("queryPlanningTimeInMillis", queryPlanningTimeInMillis)
    def getServiceProcessingTimeInMillis: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "serviceProcessingTimeInMillis",
        serviceProcessingTimeInMillis
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.QueryExecutionStatistics
  ) extends zio.aws.athena.model.QueryExecutionStatistics.ReadOnly {
    override val engineExecutionTimeInMillis: Option[Long] =
      scala.Option(impl.engineExecutionTimeInMillis()).map(value => value: Long)
    override val dataScannedInBytes: Option[Long] =
      scala.Option(impl.dataScannedInBytes()).map(value => value: Long)
    override val dataManifestLocation: Option[String] =
      scala.Option(impl.dataManifestLocation()).map(value => value: String)
    override val totalExecutionTimeInMillis: Option[Long] =
      scala.Option(impl.totalExecutionTimeInMillis()).map(value => value: Long)
    override val queryQueueTimeInMillis: Option[Long] =
      scala.Option(impl.queryQueueTimeInMillis()).map(value => value: Long)
    override val queryPlanningTimeInMillis: Option[Long] =
      scala.Option(impl.queryPlanningTimeInMillis()).map(value => value: Long)
    override val serviceProcessingTimeInMillis: Option[Long] = scala
      .Option(impl.serviceProcessingTimeInMillis())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.QueryExecutionStatistics
  ): zio.aws.athena.model.QueryExecutionStatistics.ReadOnly = new Wrapper(impl)
}
