package zio.aws.athena.model
import zio.aws.athena.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ColumnInfo(
    catalogName: Option[String] = None,
    schemaName: Option[String] = None,
    tableName: Option[String] = None,
    name: String,
    label: Option[String] = None,
    `type`: String,
    precision: Option[Integer] = None,
    scale: Option[Integer] = None,
    nullable: Option[zio.aws.athena.model.ColumnNullable] = None,
    caseSensitive: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ColumnInfo = {
    import ColumnInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ColumnInfo
      .builder()
      .optionallyWith(catalogName.map(value => value: java.lang.String))(
        _.catalogName
      )
      .optionallyWith(schemaName.map(value => value: java.lang.String))(
        _.schemaName
      )
      .optionallyWith(tableName.map(value => value: java.lang.String))(
        _.tableName
      )
      .name(name: java.lang.String)
      .optionallyWith(label.map(value => value: java.lang.String))(_.label)
      .`type`(`type`: java.lang.String)
      .optionallyWith(
        precision.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.precision)
      .optionallyWith(
        scale.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.scale)
      .optionallyWith(nullable.map(value => value.unwrap))(_.nullable)
      .optionallyWith(caseSensitive.map(value => value: java.lang.Boolean))(
        _.caseSensitive
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ColumnInfo.ReadOnly =
    zio.aws.athena.model.ColumnInfo.wrap(buildAwsValue())
}
object ColumnInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.athena.model.ColumnInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ColumnInfo =
      zio.aws.athena.model.ColumnInfo(
        catalogName.map(value => value),
        schemaName.map(value => value),
        tableName.map(value => value),
        name,
        label.map(value => value),
        `type`,
        precision.map(value => value),
        scale.map(value => value),
        nullable.map(value => value),
        caseSensitive.map(value => value)
      )
    def catalogName: Option[String]
    def schemaName: Option[String]
    def tableName: Option[String]
    def name: String
    def label: Option[String]
    def `type`: String
    def precision: Option[Integer]
    def scale: Option[Integer]
    def nullable: Option[zio.aws.athena.model.ColumnNullable]
    def caseSensitive: Option[Boolean]
    def getCatalogName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("catalogName", catalogName)
    def getSchemaName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("schemaName", schemaName)
    def getTableName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("label", label)
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
    def getPrecision: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("precision", precision)
    def getScale: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("scale", scale)
    def getNullable: ZIO[Any, AwsError, zio.aws.athena.model.ColumnNullable] =
      AwsError.unwrapOptionField("nullable", nullable)
    def getCaseSensitive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("caseSensitive", caseSensitive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ColumnInfo
  ) extends zio.aws.athena.model.ColumnInfo.ReadOnly {
    override val catalogName: Option[String] =
      scala.Option(impl.catalogName()).map(value => value: String)
    override val schemaName: Option[String] =
      scala.Option(impl.schemaName()).map(value => value: String)
    override val tableName: Option[String] =
      scala.Option(impl.tableName()).map(value => value: String)
    override val name: String = impl.name(): String
    override val label: Option[String] =
      scala.Option(impl.label()).map(value => value: String)
    override val `type`: String = impl.`type`(): String
    override val precision: Option[Integer] = scala
      .Option(impl.precision())
      .map(value => zio.aws.athena.model.primitives.Integer(value))
    override val scale: Option[Integer] = scala
      .Option(impl.scale())
      .map(value => zio.aws.athena.model.primitives.Integer(value))
    override val nullable: Option[zio.aws.athena.model.ColumnNullable] = scala
      .Option(impl.nullable())
      .map(value => zio.aws.athena.model.ColumnNullable.wrap(value))
    override val caseSensitive: Option[Boolean] =
      scala.Option(impl.caseSensitive()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ColumnInfo
  ): zio.aws.athena.model.ColumnInfo.ReadOnly = new Wrapper(impl)
}
