package zio.aws.athena.model
import java.lang.Integer
import zio.aws.athena.model.primitives.{MaxWorkGroupsCount, Token}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListWorkGroupsRequest(
    nextToken: Option[Token] = None,
    maxResults: Option[MaxWorkGroupsCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest = {
    import ListWorkGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxWorkGroupsCount.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListWorkGroupsRequest.ReadOnly =
    zio.aws.athena.model.ListWorkGroupsRequest.wrap(buildAwsValue())
}
object ListWorkGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListWorkGroupsRequest =
      zio.aws.athena.model.ListWorkGroupsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[Token]
    def maxResults: Option[MaxWorkGroupsCount]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxWorkGroupsCount] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest
  ) extends zio.aws.athena.model.ListWorkGroupsRequest.ReadOnly {
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
    override val maxResults: Option[MaxWorkGroupsCount] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.athena.model.primitives.MaxWorkGroupsCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListWorkGroupsRequest
  ): zio.aws.athena.model.ListWorkGroupsRequest.ReadOnly = new Wrapper(impl)
}
