package zio.aws.athena.model
import java.lang.Integer
import zio.aws.athena.model.primitives.{MaxTagsCount, Token, AmazonResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(
    resourceARN: AmazonResourceName,
    nextToken: Option[Token] = None,
    maxResults: Option[MaxTagsCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.ListTagsForResourceRequest
      .builder()
      .resourceARN(AmazonResourceName.unwrap(resourceARN): java.lang.String)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxTagsCount.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.athena.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.ListTagsForResourceRequest =
      zio.aws.athena.model.ListTagsForResourceRequest(
        resourceARN,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def resourceARN: AmazonResourceName
    def nextToken: Option[Token]
    def maxResults: Option[MaxTagsCount]
    def getResourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARN)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxTagsCount] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.ListTagsForResourceRequest
  ) extends zio.aws.athena.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceARN: AmazonResourceName =
      zio.aws.athena.model.primitives.AmazonResourceName(impl.resourceARN())
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
    override val maxResults: Option[MaxTagsCount] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.athena.model.primitives.MaxTagsCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.ListTagsForResourceRequest
  ): zio.aws.athena.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
