package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSourceApiAssociationResponse(
    sourceApiAssociation: Optional[zio.aws.appsync.model.SourceApiAssociation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.UpdateSourceApiAssociationResponse = {
    import UpdateSourceApiAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.UpdateSourceApiAssociationResponse
      .builder()
      .optionallyWith(sourceApiAssociation.map(value => value.buildAwsValue()))(
        _.sourceApiAssociation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appsync.model.UpdateSourceApiAssociationResponse.ReadOnly =
    zio.aws.appsync.model.UpdateSourceApiAssociationResponse
      .wrap(buildAwsValue())
}
object UpdateSourceApiAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.UpdateSourceApiAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.UpdateSourceApiAssociationResponse =
      zio.aws.appsync.model.UpdateSourceApiAssociationResponse(
        sourceApiAssociation.map(value => value.asEditable)
      )
    def sourceApiAssociation
        : Optional[zio.aws.appsync.model.SourceApiAssociation.ReadOnly]
    def getSourceApiAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.SourceApiAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("sourceApiAssociation", sourceApiAssociation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.UpdateSourceApiAssociationResponse
  ) extends zio.aws.appsync.model.UpdateSourceApiAssociationResponse.ReadOnly {
    override val sourceApiAssociation
        : Optional[zio.aws.appsync.model.SourceApiAssociation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceApiAssociation())
        .map(value => zio.aws.appsync.model.SourceApiAssociation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.UpdateSourceApiAssociationResponse
  ): zio.aws.appsync.model.UpdateSourceApiAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
