package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSourceApiAssociationResponse(
    sourceApiAssociation: Optional[zio.aws.appsync.model.SourceApiAssociation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.GetSourceApiAssociationResponse = {
    import GetSourceApiAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.GetSourceApiAssociationResponse
      .builder()
      .optionallyWith(sourceApiAssociation.map(value => value.buildAwsValue()))(
        _.sourceApiAssociation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appsync.model.GetSourceApiAssociationResponse.ReadOnly =
    zio.aws.appsync.model.GetSourceApiAssociationResponse.wrap(buildAwsValue())
}
object GetSourceApiAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.GetSourceApiAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.GetSourceApiAssociationResponse =
      zio.aws.appsync.model.GetSourceApiAssociationResponse(
        sourceApiAssociation.map(value => value.asEditable)
      )
    def sourceApiAssociation
        : Optional[zio.aws.appsync.model.SourceApiAssociation.ReadOnly]
    def getSourceApiAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.SourceApiAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("sourceApiAssociation", sourceApiAssociation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.GetSourceApiAssociationResponse
  ) extends zio.aws.appsync.model.GetSourceApiAssociationResponse.ReadOnly {
    override val sourceApiAssociation
        : Optional[zio.aws.appsync.model.SourceApiAssociation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceApiAssociation())
        .map(value => zio.aws.appsync.model.SourceApiAssociation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.GetSourceApiAssociationResponse
  ): zio.aws.appsync.model.GetSourceApiAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
