package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociateMergedGraphqlApiResponse(
    sourceApiAssociation: Optional[zio.aws.appsync.model.SourceApiAssociation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.AssociateMergedGraphqlApiResponse = {
    import AssociateMergedGraphqlApiResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.AssociateMergedGraphqlApiResponse
      .builder()
      .optionallyWith(sourceApiAssociation.map(value => value.buildAwsValue()))(
        _.sourceApiAssociation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appsync.model.AssociateMergedGraphqlApiResponse.ReadOnly =
    zio.aws.appsync.model.AssociateMergedGraphqlApiResponse
      .wrap(buildAwsValue())
}
object AssociateMergedGraphqlApiResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.AssociateMergedGraphqlApiResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.AssociateMergedGraphqlApiResponse =
      zio.aws.appsync.model.AssociateMergedGraphqlApiResponse(
        sourceApiAssociation.map(value => value.asEditable)
      )
    def sourceApiAssociation
        : Optional[zio.aws.appsync.model.SourceApiAssociation.ReadOnly]
    def getSourceApiAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.SourceApiAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("sourceApiAssociation", sourceApiAssociation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.AssociateMergedGraphqlApiResponse
  ) extends zio.aws.appsync.model.AssociateMergedGraphqlApiResponse.ReadOnly {
    override val sourceApiAssociation
        : Optional[zio.aws.appsync.model.SourceApiAssociation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceApiAssociation())
        .map(value => zio.aws.appsync.model.SourceApiAssociation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.AssociateMergedGraphqlApiResponse
  ): zio.aws.appsync.model.AssociateMergedGraphqlApiResponse.ReadOnly =
    new Wrapper(impl)
}
