package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDataSourcesResponse(
    dataSources: Optional[Iterable[zio.aws.appsync.model.DataSource]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ListDataSourcesResponse = {
    import ListDataSourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ListDataSourcesResponse
      .builder()
      .optionallyWith(
        dataSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataSources)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.ListDataSourcesResponse.ReadOnly =
    zio.aws.appsync.model.ListDataSourcesResponse.wrap(buildAwsValue())
}
object ListDataSourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ListDataSourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ListDataSourcesResponse =
      zio.aws.appsync.model.ListDataSourcesResponse(
        dataSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def dataSources: Optional[List[zio.aws.appsync.model.DataSource.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getDataSources
        : ZIO[Any, AwsError, List[zio.aws.appsync.model.DataSource.ReadOnly]] =
      AwsError.unwrapOptionField("dataSources", dataSources)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ListDataSourcesResponse
  ) extends zio.aws.appsync.model.ListDataSourcesResponse.ReadOnly {
    override val dataSources
        : Optional[List[zio.aws.appsync.model.DataSource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appsync.model.DataSource.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appsync.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ListDataSourcesResponse
  ): zio.aws.appsync.model.ListDataSourcesResponse.ReadOnly = new Wrapper(impl)
}
