package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteApiCacheRequest(apiId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.DeleteApiCacheRequest = {
    import DeleteApiCacheRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.DeleteApiCacheRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.DeleteApiCacheRequest.ReadOnly =
    zio.aws.appsync.model.DeleteApiCacheRequest.wrap(buildAwsValue())
}
object DeleteApiCacheRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.DeleteApiCacheRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.DeleteApiCacheRequest =
      zio.aws.appsync.model.DeleteApiCacheRequest(apiId)
    def apiId: String
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.DeleteApiCacheRequest
  ) extends zio.aws.appsync.model.DeleteApiCacheRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.DeleteApiCacheRequest
  ): zio.aws.appsync.model.DeleteApiCacheRequest.ReadOnly = new Wrapper(impl)
}
