package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateTypeRequest(
    apiId: String,
    typeName: ResourceName,
    definition: Optional[String] = Optional.Absent,
    format: zio.aws.appsync.model.TypeDefinitionFormat
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.UpdateTypeRequest = {
    import UpdateTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.UpdateTypeRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .typeName(ResourceName.unwrap(typeName): java.lang.String)
      .optionallyWith(definition.map(value => value: java.lang.String))(
        _.definition
      )
      .format(format.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.UpdateTypeRequest.ReadOnly =
    zio.aws.appsync.model.UpdateTypeRequest.wrap(buildAwsValue())
}
object UpdateTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.UpdateTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.UpdateTypeRequest =
      zio.aws.appsync.model.UpdateTypeRequest(
        apiId,
        typeName,
        definition.map(value => value),
        format
      )
    def apiId: String
    def typeName: ResourceName
    def definition: Optional[String]
    def format: zio.aws.appsync.model.TypeDefinitionFormat
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getTypeName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(typeName)
    def getDefinition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("definition", definition)
    def getFormat
        : ZIO[Any, Nothing, zio.aws.appsync.model.TypeDefinitionFormat] =
      ZIO.succeed(format)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.UpdateTypeRequest
  ) extends zio.aws.appsync.model.UpdateTypeRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val typeName: ResourceName =
      zio.aws.appsync.model.primitives.ResourceName(impl.typeName())
    override val definition: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.definition())
      .map(value => value: String)
    override val format: zio.aws.appsync.model.TypeDefinitionFormat =
      zio.aws.appsync.model.TypeDefinitionFormat.wrap(impl.format())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.UpdateTypeRequest
  ): zio.aws.appsync.model.UpdateTypeRequest.ReadOnly = new Wrapper(impl)
}
