package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeltaSyncConfig(
    baseTableTTL: Optional[Long] = Optional.Absent,
    deltaSyncTableName: Optional[String] = Optional.Absent,
    deltaSyncTableTTL: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.DeltaSyncConfig = {
    import DeltaSyncConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.DeltaSyncConfig
      .builder()
      .optionallyWith(baseTableTTL.map(value => value: java.lang.Long))(
        _.baseTableTTL
      )
      .optionallyWith(deltaSyncTableName.map(value => value: java.lang.String))(
        _.deltaSyncTableName
      )
      .optionallyWith(deltaSyncTableTTL.map(value => value: java.lang.Long))(
        _.deltaSyncTableTTL
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.DeltaSyncConfig.ReadOnly =
    zio.aws.appsync.model.DeltaSyncConfig.wrap(buildAwsValue())
}
object DeltaSyncConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.DeltaSyncConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.DeltaSyncConfig =
      zio.aws.appsync.model.DeltaSyncConfig(
        baseTableTTL.map(value => value),
        deltaSyncTableName.map(value => value),
        deltaSyncTableTTL.map(value => value)
      )
    def baseTableTTL: Optional[Long]
    def deltaSyncTableName: Optional[String]
    def deltaSyncTableTTL: Optional[Long]
    def getBaseTableTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("baseTableTTL", baseTableTTL)
    def getDeltaSyncTableName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deltaSyncTableName", deltaSyncTableName)
    def getDeltaSyncTableTTL: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("deltaSyncTableTTL", deltaSyncTableTTL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.DeltaSyncConfig
  ) extends zio.aws.appsync.model.DeltaSyncConfig.ReadOnly {
    override val baseTableTTL: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.baseTableTTL())
      .map(value => value: Long)
    override val deltaSyncTableName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deltaSyncTableName())
      .map(value => value: String)
    override val deltaSyncTableTTL: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.deltaSyncTableTTL())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.DeltaSyncConfig
  ): zio.aws.appsync.model.DeltaSyncConfig.ReadOnly = new Wrapper(impl)
}
