package zio.aws.appsync.model
import scala.jdk.CollectionConverters.*
sealed trait DataSourceType {
  def unwrap: software.amazon.awssdk.services.appsync.model.DataSourceType
}
object DataSourceType {
  def wrap(
      value: software.amazon.awssdk.services.appsync.model.DataSourceType
  ): zio.aws.appsync.model.DataSourceType = value match {
    case software.amazon.awssdk.services.appsync.model.DataSourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appsync.model.DataSourceType.AWS_LAMBDA =>
      val r = AWS_LAMBDA
      r
    case software.amazon.awssdk.services.appsync.model.DataSourceType.AMAZON_DYNAMODB =>
      val r = AMAZON_DYNAMODB
      r
    case software.amazon.awssdk.services.appsync.model.DataSourceType.AMAZON_ELASTICSEARCH =>
      val r = AMAZON_ELASTICSEARCH
      r
    case software.amazon.awssdk.services.appsync.model.DataSourceType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.appsync.model.DataSourceType.HTTP =>
      val r = HTTP
      r
    case software.amazon.awssdk.services.appsync.model.DataSourceType.RELATIONAL_DATABASE =>
      val r = RELATIONAL_DATABASE
      r
    case software.amazon.awssdk.services.appsync.model.DataSourceType.AMAZON_OPENSEARCH_SERVICE =>
      val r = AMAZON_OPENSEARCH_SERVICE
      r
    case software.amazon.awssdk.services.appsync.model.DataSourceType.AMAZON_EVENTBRIDGE =>
      val r = AMAZON_EVENTBRIDGE
      r
  }
  case object unknownToSdkVersion extends zio.aws.appsync.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.DataSourceType =
      software.amazon.awssdk.services.appsync.model.DataSourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_LAMBDA extends zio.aws.appsync.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.DataSourceType =
      software.amazon.awssdk.services.appsync.model.DataSourceType.AWS_LAMBDA
  }
  case object AMAZON_DYNAMODB extends zio.aws.appsync.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.DataSourceType =
      software.amazon.awssdk.services.appsync.model.DataSourceType.AMAZON_DYNAMODB
  }
  case object AMAZON_ELASTICSEARCH
      extends zio.aws.appsync.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.DataSourceType =
      software.amazon.awssdk.services.appsync.model.DataSourceType.AMAZON_ELASTICSEARCH
  }
  case object NONE extends zio.aws.appsync.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.DataSourceType =
      software.amazon.awssdk.services.appsync.model.DataSourceType.NONE
  }
  case object HTTP extends zio.aws.appsync.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.DataSourceType =
      software.amazon.awssdk.services.appsync.model.DataSourceType.HTTP
  }
  case object RELATIONAL_DATABASE extends zio.aws.appsync.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.DataSourceType =
      software.amazon.awssdk.services.appsync.model.DataSourceType.RELATIONAL_DATABASE
  }
  case object AMAZON_OPENSEARCH_SERVICE
      extends zio.aws.appsync.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.DataSourceType =
      software.amazon.awssdk.services.appsync.model.DataSourceType.AMAZON_OPENSEARCH_SERVICE
  }
  case object AMAZON_EVENTBRIDGE extends zio.aws.appsync.model.DataSourceType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.DataSourceType =
      software.amazon.awssdk.services.appsync.model.DataSourceType.AMAZON_EVENTBRIDGE
  }
}
