package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetApiAssociationResponse(
    apiAssociation: Optional[zio.aws.appsync.model.ApiAssociation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.GetApiAssociationResponse = {
    import GetApiAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.GetApiAssociationResponse
      .builder()
      .optionallyWith(apiAssociation.map(value => value.buildAwsValue()))(
        _.apiAssociation
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.GetApiAssociationResponse.ReadOnly =
    zio.aws.appsync.model.GetApiAssociationResponse.wrap(buildAwsValue())
}
object GetApiAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.GetApiAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.GetApiAssociationResponse =
      zio.aws.appsync.model.GetApiAssociationResponse(
        apiAssociation.map(value => value.asEditable)
      )
    def apiAssociation: Optional[zio.aws.appsync.model.ApiAssociation.ReadOnly]
    def getApiAssociation
        : ZIO[Any, AwsError, zio.aws.appsync.model.ApiAssociation.ReadOnly] =
      AwsError.unwrapOptionField("apiAssociation", apiAssociation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.GetApiAssociationResponse
  ) extends zio.aws.appsync.model.GetApiAssociationResponse.ReadOnly {
    override val apiAssociation
        : Optional[zio.aws.appsync.model.ApiAssociation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiAssociation())
        .map(value => zio.aws.appsync.model.ApiAssociation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.GetApiAssociationResponse
  ): zio.aws.appsync.model.GetApiAssociationResponse.ReadOnly = new Wrapper(
    impl
  )
}
