package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataSource(
    dataSourceArn: Optional[String] = Optional.Absent,
    name: Optional[ResourceName] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    `type`: Optional[zio.aws.appsync.model.DataSourceType] = Optional.Absent,
    serviceRoleArn: Optional[String] = Optional.Absent,
    dynamodbConfig: Optional[zio.aws.appsync.model.DynamodbDataSourceConfig] =
      Optional.Absent,
    lambdaConfig: Optional[zio.aws.appsync.model.LambdaDataSourceConfig] =
      Optional.Absent,
    elasticsearchConfig: Optional[
      zio.aws.appsync.model.ElasticsearchDataSourceConfig
    ] = Optional.Absent,
    openSearchServiceConfig: Optional[
      zio.aws.appsync.model.OpenSearchServiceDataSourceConfig
    ] = Optional.Absent,
    httpConfig: Optional[zio.aws.appsync.model.HttpDataSourceConfig] =
      Optional.Absent,
    relationalDatabaseConfig: Optional[
      zio.aws.appsync.model.RelationalDatabaseDataSourceConfig
    ] = Optional.Absent,
    eventBridgeConfig: Optional[
      zio.aws.appsync.model.EventBridgeDataSourceConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.DataSource = {
    import DataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.DataSource
      .builder()
      .optionallyWith(dataSourceArn.map(value => value: java.lang.String))(
        _.dataSourceArn
      )
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(serviceRoleArn.map(value => value: java.lang.String))(
        _.serviceRoleArn
      )
      .optionallyWith(dynamodbConfig.map(value => value.buildAwsValue()))(
        _.dynamodbConfig
      )
      .optionallyWith(lambdaConfig.map(value => value.buildAwsValue()))(
        _.lambdaConfig
      )
      .optionallyWith(elasticsearchConfig.map(value => value.buildAwsValue()))(
        _.elasticsearchConfig
      )
      .optionallyWith(
        openSearchServiceConfig.map(value => value.buildAwsValue())
      )(_.openSearchServiceConfig)
      .optionallyWith(httpConfig.map(value => value.buildAwsValue()))(
        _.httpConfig
      )
      .optionallyWith(
        relationalDatabaseConfig.map(value => value.buildAwsValue())
      )(_.relationalDatabaseConfig)
      .optionallyWith(eventBridgeConfig.map(value => value.buildAwsValue()))(
        _.eventBridgeConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.DataSource.ReadOnly =
    zio.aws.appsync.model.DataSource.wrap(buildAwsValue())
}
object DataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.DataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.DataSource =
      zio.aws.appsync.model.DataSource(
        dataSourceArn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        `type`.map(value => value),
        serviceRoleArn.map(value => value),
        dynamodbConfig.map(value => value.asEditable),
        lambdaConfig.map(value => value.asEditable),
        elasticsearchConfig.map(value => value.asEditable),
        openSearchServiceConfig.map(value => value.asEditable),
        httpConfig.map(value => value.asEditable),
        relationalDatabaseConfig.map(value => value.asEditable),
        eventBridgeConfig.map(value => value.asEditable)
      )
    def dataSourceArn: Optional[String]
    def name: Optional[ResourceName]
    def description: Optional[String]
    def `type`: Optional[zio.aws.appsync.model.DataSourceType]
    def serviceRoleArn: Optional[String]
    def dynamodbConfig
        : Optional[zio.aws.appsync.model.DynamodbDataSourceConfig.ReadOnly]
    def lambdaConfig
        : Optional[zio.aws.appsync.model.LambdaDataSourceConfig.ReadOnly]
    def elasticsearchConfig
        : Optional[zio.aws.appsync.model.ElasticsearchDataSourceConfig.ReadOnly]
    def openSearchServiceConfig: Optional[
      zio.aws.appsync.model.OpenSearchServiceDataSourceConfig.ReadOnly
    ]
    def httpConfig
        : Optional[zio.aws.appsync.model.HttpDataSourceConfig.ReadOnly]
    def relationalDatabaseConfig: Optional[
      zio.aws.appsync.model.RelationalDatabaseDataSourceConfig.ReadOnly
    ]
    def eventBridgeConfig
        : Optional[zio.aws.appsync.model.EventBridgeDataSourceConfig.ReadOnly]
    def getDataSourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataSourceArn", dataSourceArn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, AwsError, zio.aws.appsync.model.DataSourceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getServiceRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceRoleArn", serviceRoleArn)
    def getDynamodbConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.DynamodbDataSourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dynamodbConfig", dynamodbConfig)
    def getLambdaConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.LambdaDataSourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("lambdaConfig", lambdaConfig)
    def getElasticsearchConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.ElasticsearchDataSourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("elasticsearchConfig", elasticsearchConfig)
    def getOpenSearchServiceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.OpenSearchServiceDataSourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "openSearchServiceConfig",
      openSearchServiceConfig
    )
    def getHttpConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.HttpDataSourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("httpConfig", httpConfig)
    def getRelationalDatabaseConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.RelationalDatabaseDataSourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "relationalDatabaseConfig",
      relationalDatabaseConfig
    )
    def getEventBridgeConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.EventBridgeDataSourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField("eventBridgeConfig", eventBridgeConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.DataSource
  ) extends zio.aws.appsync.model.DataSource.ReadOnly {
    override val dataSourceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSourceArn())
      .map(value => value: String)
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.appsync.model.primitives.ResourceName(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val `type`: Optional[zio.aws.appsync.model.DataSourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.appsync.model.DataSourceType.wrap(value))
    override val serviceRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRoleArn())
      .map(value => value: String)
    override val dynamodbConfig
        : Optional[zio.aws.appsync.model.DynamodbDataSourceConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dynamodbConfig())
        .map(value =>
          zio.aws.appsync.model.DynamodbDataSourceConfig.wrap(value)
        )
    override val lambdaConfig
        : Optional[zio.aws.appsync.model.LambdaDataSourceConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambdaConfig())
        .map(value => zio.aws.appsync.model.LambdaDataSourceConfig.wrap(value))
    override val elasticsearchConfig: Optional[
      zio.aws.appsync.model.ElasticsearchDataSourceConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticsearchConfig())
      .map(value =>
        zio.aws.appsync.model.ElasticsearchDataSourceConfig.wrap(value)
      )
    override val openSearchServiceConfig: Optional[
      zio.aws.appsync.model.OpenSearchServiceDataSourceConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.openSearchServiceConfig())
      .map(value =>
        zio.aws.appsync.model.OpenSearchServiceDataSourceConfig.wrap(value)
      )
    override val httpConfig
        : Optional[zio.aws.appsync.model.HttpDataSourceConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpConfig())
        .map(value => zio.aws.appsync.model.HttpDataSourceConfig.wrap(value))
    override val relationalDatabaseConfig: Optional[
      zio.aws.appsync.model.RelationalDatabaseDataSourceConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.relationalDatabaseConfig())
      .map(value =>
        zio.aws.appsync.model.RelationalDatabaseDataSourceConfig.wrap(value)
      )
    override val eventBridgeConfig
        : Optional[zio.aws.appsync.model.EventBridgeDataSourceConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventBridgeConfig())
        .map(value =>
          zio.aws.appsync.model.EventBridgeDataSourceConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.DataSource
  ): zio.aws.appsync.model.DataSource.ReadOnly = new Wrapper(impl)
}
