package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SourceApiAssociationSummary(
    associationId: Optional[String] = Optional.Absent,
    associationArn: Optional[String] = Optional.Absent,
    sourceApiId: Optional[String] = Optional.Absent,
    sourceApiArn: Optional[String] = Optional.Absent,
    mergedApiId: Optional[String] = Optional.Absent,
    mergedApiArn: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.SourceApiAssociationSummary = {
    import SourceApiAssociationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.SourceApiAssociationSummary
      .builder()
      .optionallyWith(associationId.map(value => value: java.lang.String))(
        _.associationId
      )
      .optionallyWith(associationArn.map(value => value: java.lang.String))(
        _.associationArn
      )
      .optionallyWith(sourceApiId.map(value => value: java.lang.String))(
        _.sourceApiId
      )
      .optionallyWith(sourceApiArn.map(value => value: java.lang.String))(
        _.sourceApiArn
      )
      .optionallyWith(mergedApiId.map(value => value: java.lang.String))(
        _.mergedApiId
      )
      .optionallyWith(mergedApiArn.map(value => value: java.lang.String))(
        _.mergedApiArn
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.SourceApiAssociationSummary.ReadOnly =
    zio.aws.appsync.model.SourceApiAssociationSummary.wrap(buildAwsValue())
}
object SourceApiAssociationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.SourceApiAssociationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.SourceApiAssociationSummary =
      zio.aws.appsync.model.SourceApiAssociationSummary(
        associationId.map(value => value),
        associationArn.map(value => value),
        sourceApiId.map(value => value),
        sourceApiArn.map(value => value),
        mergedApiId.map(value => value),
        mergedApiArn.map(value => value),
        description.map(value => value)
      )
    def associationId: Optional[String]
    def associationArn: Optional[String]
    def sourceApiId: Optional[String]
    def sourceApiArn: Optional[String]
    def mergedApiId: Optional[String]
    def mergedApiArn: Optional[String]
    def description: Optional[String]
    def getAssociationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getAssociationArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associationArn", associationArn)
    def getSourceApiId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceApiId", sourceApiId)
    def getSourceApiArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceApiArn", sourceApiArn)
    def getMergedApiId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("mergedApiId", mergedApiId)
    def getMergedApiArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("mergedApiArn", mergedApiArn)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.SourceApiAssociationSummary
  ) extends zio.aws.appsync.model.SourceApiAssociationSummary.ReadOnly {
    override val associationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => value: String)
    override val associationArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.associationArn())
      .map(value => value: String)
    override val sourceApiId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceApiId())
      .map(value => value: String)
    override val sourceApiArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceApiArn())
      .map(value => value: String)
    override val mergedApiId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.mergedApiId())
      .map(value => value: String)
    override val mergedApiArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.mergedApiArn())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.SourceApiAssociationSummary
  ): zio.aws.appsync.model.SourceApiAssociationSummary.ReadOnly = new Wrapper(
    impl
  )
}
