package zio.aws.appsync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.appsync.model.primitives.{
  Code,
  MaxBatchSize,
  MappingTemplate,
  ResourceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Resolver(
    typeName: Optional[ResourceName] = Optional.Absent,
    fieldName: Optional[ResourceName] = Optional.Absent,
    dataSourceName: Optional[ResourceName] = Optional.Absent,
    resolverArn: Optional[String] = Optional.Absent,
    requestMappingTemplate: Optional[MappingTemplate] = Optional.Absent,
    responseMappingTemplate: Optional[MappingTemplate] = Optional.Absent,
    kind: Optional[zio.aws.appsync.model.ResolverKind] = Optional.Absent,
    pipelineConfig: Optional[zio.aws.appsync.model.PipelineConfig] =
      Optional.Absent,
    syncConfig: Optional[zio.aws.appsync.model.SyncConfig] = Optional.Absent,
    cachingConfig: Optional[zio.aws.appsync.model.CachingConfig] =
      Optional.Absent,
    maxBatchSize: Optional[MaxBatchSize] = Optional.Absent,
    runtime: Optional[zio.aws.appsync.model.AppSyncRuntime] = Optional.Absent,
    code: Optional[Code] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.Resolver = {
    import Resolver.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.Resolver
      .builder()
      .optionallyWith(
        typeName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        fieldName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.fieldName)
      .optionallyWith(
        dataSourceName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.dataSourceName)
      .optionallyWith(resolverArn.map(value => value: java.lang.String))(
        _.resolverArn
      )
      .optionallyWith(
        requestMappingTemplate.map(value =>
          MappingTemplate.unwrap(value): java.lang.String
        )
      )(_.requestMappingTemplate)
      .optionallyWith(
        responseMappingTemplate.map(value =>
          MappingTemplate.unwrap(value): java.lang.String
        )
      )(_.responseMappingTemplate)
      .optionallyWith(kind.map(value => value.unwrap))(_.kind)
      .optionallyWith(pipelineConfig.map(value => value.buildAwsValue()))(
        _.pipelineConfig
      )
      .optionallyWith(syncConfig.map(value => value.buildAwsValue()))(
        _.syncConfig
      )
      .optionallyWith(cachingConfig.map(value => value.buildAwsValue()))(
        _.cachingConfig
      )
      .optionallyWith(
        maxBatchSize.map(value => MaxBatchSize.unwrap(value): Integer)
      )(_.maxBatchSize)
      .optionallyWith(runtime.map(value => value.buildAwsValue()))(_.runtime)
      .optionallyWith(code.map(value => Code.unwrap(value): java.lang.String))(
        _.code
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.Resolver.ReadOnly =
    zio.aws.appsync.model.Resolver.wrap(buildAwsValue())
}
object Resolver {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appsync.model.Resolver] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.Resolver =
      zio.aws.appsync.model.Resolver(
        typeName.map(value => value),
        fieldName.map(value => value),
        dataSourceName.map(value => value),
        resolverArn.map(value => value),
        requestMappingTemplate.map(value => value),
        responseMappingTemplate.map(value => value),
        kind.map(value => value),
        pipelineConfig.map(value => value.asEditable),
        syncConfig.map(value => value.asEditable),
        cachingConfig.map(value => value.asEditable),
        maxBatchSize.map(value => value),
        runtime.map(value => value.asEditable),
        code.map(value => value)
      )
    def typeName: Optional[ResourceName]
    def fieldName: Optional[ResourceName]
    def dataSourceName: Optional[ResourceName]
    def resolverArn: Optional[String]
    def requestMappingTemplate: Optional[MappingTemplate]
    def responseMappingTemplate: Optional[MappingTemplate]
    def kind: Optional[zio.aws.appsync.model.ResolverKind]
    def pipelineConfig: Optional[zio.aws.appsync.model.PipelineConfig.ReadOnly]
    def syncConfig: Optional[zio.aws.appsync.model.SyncConfig.ReadOnly]
    def cachingConfig: Optional[zio.aws.appsync.model.CachingConfig.ReadOnly]
    def maxBatchSize: Optional[MaxBatchSize]
    def runtime: Optional[zio.aws.appsync.model.AppSyncRuntime.ReadOnly]
    def code: Optional[Code]
    def getTypeName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getFieldName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("fieldName", fieldName)
    def getDataSourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("dataSourceName", dataSourceName)
    def getResolverArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resolverArn", resolverArn)
    def getRequestMappingTemplate: ZIO[Any, AwsError, MappingTemplate] =
      AwsError.unwrapOptionField(
        "requestMappingTemplate",
        requestMappingTemplate
      )
    def getResponseMappingTemplate: ZIO[Any, AwsError, MappingTemplate] =
      AwsError.unwrapOptionField(
        "responseMappingTemplate",
        responseMappingTemplate
      )
    def getKind: ZIO[Any, AwsError, zio.aws.appsync.model.ResolverKind] =
      AwsError.unwrapOptionField("kind", kind)
    def getPipelineConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.PipelineConfig.ReadOnly] =
      AwsError.unwrapOptionField("pipelineConfig", pipelineConfig)
    def getSyncConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.SyncConfig.ReadOnly] =
      AwsError.unwrapOptionField("syncConfig", syncConfig)
    def getCachingConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.CachingConfig.ReadOnly] =
      AwsError.unwrapOptionField("cachingConfig", cachingConfig)
    def getMaxBatchSize: ZIO[Any, AwsError, MaxBatchSize] =
      AwsError.unwrapOptionField("maxBatchSize", maxBatchSize)
    def getRuntime
        : ZIO[Any, AwsError, zio.aws.appsync.model.AppSyncRuntime.ReadOnly] =
      AwsError.unwrapOptionField("runtime", runtime)
    def getCode: ZIO[Any, AwsError, Code] =
      AwsError.unwrapOptionField("code", code)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.Resolver
  ) extends zio.aws.appsync.model.Resolver.ReadOnly {
    override val typeName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.typeName())
      .map(value => zio.aws.appsync.model.primitives.ResourceName(value))
    override val fieldName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.fieldName())
      .map(value => zio.aws.appsync.model.primitives.ResourceName(value))
    override val dataSourceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSourceName())
      .map(value => zio.aws.appsync.model.primitives.ResourceName(value))
    override val resolverArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resolverArn())
      .map(value => value: String)
    override val requestMappingTemplate: Optional[MappingTemplate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestMappingTemplate())
        .map(value => zio.aws.appsync.model.primitives.MappingTemplate(value))
    override val responseMappingTemplate: Optional[MappingTemplate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseMappingTemplate())
        .map(value => zio.aws.appsync.model.primitives.MappingTemplate(value))
    override val kind: Optional[zio.aws.appsync.model.ResolverKind] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kind())
        .map(value => zio.aws.appsync.model.ResolverKind.wrap(value))
    override val pipelineConfig
        : Optional[zio.aws.appsync.model.PipelineConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineConfig())
        .map(value => zio.aws.appsync.model.PipelineConfig.wrap(value))
    override val syncConfig
        : Optional[zio.aws.appsync.model.SyncConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.syncConfig())
        .map(value => zio.aws.appsync.model.SyncConfig.wrap(value))
    override val cachingConfig
        : Optional[zio.aws.appsync.model.CachingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cachingConfig())
        .map(value => zio.aws.appsync.model.CachingConfig.wrap(value))
    override val maxBatchSize: Optional[MaxBatchSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxBatchSize())
      .map(value => zio.aws.appsync.model.primitives.MaxBatchSize(value))
    override val runtime
        : Optional[zio.aws.appsync.model.AppSyncRuntime.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtime())
        .map(value => zio.aws.appsync.model.AppSyncRuntime.wrap(value))
    override val code: Optional[Code] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => zio.aws.appsync.model.primitives.Code(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.Resolver
  ): zio.aws.appsync.model.Resolver.ReadOnly = new Wrapper(impl)
}
