package zio.aws.appsync.model
import scala.jdk.CollectionConverters.*
sealed trait GraphQLApiVisibility {
  def unwrap: software.amazon.awssdk.services.appsync.model.GraphQLApiVisibility
}
object GraphQLApiVisibility {
  def wrap(
      value: software.amazon.awssdk.services.appsync.model.GraphQLApiVisibility
  ): zio.aws.appsync.model.GraphQLApiVisibility = value match {
    case software.amazon.awssdk.services.appsync.model.GraphQLApiVisibility.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appsync.model.GraphQLApiVisibility.GLOBAL =>
      val r = GLOBAL
      r
    case software.amazon.awssdk.services.appsync.model.GraphQLApiVisibility.PRIVATE =>
      val r = PRIVATE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appsync.model.GraphQLApiVisibility {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.GraphQLApiVisibility =
      software.amazon.awssdk.services.appsync.model.GraphQLApiVisibility.UNKNOWN_TO_SDK_VERSION
  }
  case object GLOBAL extends zio.aws.appsync.model.GraphQLApiVisibility {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.GraphQLApiVisibility =
      software.amazon.awssdk.services.appsync.model.GraphQLApiVisibility.GLOBAL
  }
  case object PRIVATE extends zio.aws.appsync.model.GraphQLApiVisibility {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.GraphQLApiVisibility =
      software.amazon.awssdk.services.appsync.model.GraphQLApiVisibility.PRIVATE
  }
}
