package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.{Context, Code}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EvaluateCodeRequest(
    runtime: zio.aws.appsync.model.AppSyncRuntime,
    code: Code,
    context: Context,
    function: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.EvaluateCodeRequest = {
    import EvaluateCodeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.EvaluateCodeRequest
      .builder()
      .runtime(runtime.buildAwsValue())
      .code(Code.unwrap(code): java.lang.String)
      .context(Context.unwrap(context): java.lang.String)
      .optionallyWith(function.map(value => value: java.lang.String))(
        _.function
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.EvaluateCodeRequest.ReadOnly =
    zio.aws.appsync.model.EvaluateCodeRequest.wrap(buildAwsValue())
}
object EvaluateCodeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.EvaluateCodeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.EvaluateCodeRequest =
      zio.aws.appsync.model.EvaluateCodeRequest(
        runtime.asEditable,
        code,
        context,
        function.map(value => value)
      )
    def runtime: zio.aws.appsync.model.AppSyncRuntime.ReadOnly
    def code: Code
    def context: Context
    def function: Optional[String]
    def getRuntime
        : ZIO[Any, Nothing, zio.aws.appsync.model.AppSyncRuntime.ReadOnly] =
      ZIO.succeed(runtime)
    def getCode: ZIO[Any, Nothing, Code] = ZIO.succeed(code)
    def getContext: ZIO[Any, Nothing, Context] = ZIO.succeed(context)
    def getFunction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("function", function)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.EvaluateCodeRequest
  ) extends zio.aws.appsync.model.EvaluateCodeRequest.ReadOnly {
    override val runtime: zio.aws.appsync.model.AppSyncRuntime.ReadOnly =
      zio.aws.appsync.model.AppSyncRuntime.wrap(impl.runtime())
    override val code: Code = zio.aws.appsync.model.primitives.Code(impl.code())
    override val context: Context =
      zio.aws.appsync.model.primitives.Context(impl.context())
    override val function: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.function())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.EvaluateCodeRequest
  ): zio.aws.appsync.model.EvaluateCodeRequest.ReadOnly = new Wrapper(impl)
}
