package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AssociateApiRequest(domainName: DomainName, apiId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.AssociateApiRequest = {
    import AssociateApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.AssociateApiRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .apiId(apiId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.AssociateApiRequest.ReadOnly =
    zio.aws.appsync.model.AssociateApiRequest.wrap(buildAwsValue())
}
object AssociateApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.AssociateApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.AssociateApiRequest =
      zio.aws.appsync.model.AssociateApiRequest(domainName, apiId)
    def domainName: DomainName
    def apiId: String
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.AssociateApiRequest
  ) extends zio.aws.appsync.model.AssociateApiRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.appsync.model.primitives.DomainName(impl.domainName())
    override val apiId: String = impl.apiId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.AssociateApiRequest
  ): zio.aws.appsync.model.AssociateApiRequest.ReadOnly = new Wrapper(impl)
}
