package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTypesByAssociationResponse(
    types: Optional[Iterable[zio.aws.appsync.model.Type]] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ListTypesByAssociationResponse = {
    import ListTypesByAssociationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ListTypesByAssociationResponse
      .builder()
      .optionallyWith(
        types.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.types)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appsync.model.ListTypesByAssociationResponse.ReadOnly =
    zio.aws.appsync.model.ListTypesByAssociationResponse.wrap(buildAwsValue())
}
object ListTypesByAssociationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ListTypesByAssociationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ListTypesByAssociationResponse =
      zio.aws.appsync.model.ListTypesByAssociationResponse(
        types.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def types: Optional[List[zio.aws.appsync.model.Type.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getTypes
        : ZIO[Any, AwsError, List[zio.aws.appsync.model.Type.ReadOnly]] =
      AwsError.unwrapOptionField("types", types)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ListTypesByAssociationResponse
  ) extends zio.aws.appsync.model.ListTypesByAssociationResponse.ReadOnly {
    override val types: Optional[List[zio.aws.appsync.model.Type.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.types())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appsync.model.Type.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appsync.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ListTypesByAssociationResponse
  ): zio.aws.appsync.model.ListTypesByAssociationResponse.ReadOnly =
    new Wrapper(impl)
}
