package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CachingConfig(
    ttl: Long,
    cachingKeys: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CachingConfig = {
    import CachingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CachingConfig
      .builder()
      .ttl(ttl: java.lang.Long)
      .optionallyWith(
        cachingKeys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cachingKeys)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CachingConfig.ReadOnly =
    zio.aws.appsync.model.CachingConfig.wrap(buildAwsValue())
}
object CachingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.CachingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CachingConfig =
      zio.aws.appsync.model.CachingConfig(ttl, cachingKeys.map(value => value))
    def ttl: Long
    def cachingKeys: Optional[List[String]]
    def getTtl: ZIO[Any, Nothing, Long] = ZIO.succeed(ttl)
    def getCachingKeys: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cachingKeys", cachingKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CachingConfig
  ) extends zio.aws.appsync.model.CachingConfig.ReadOnly {
    override val ttl: Long = impl.ttl(): Long
    override val cachingKeys: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.cachingKeys())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CachingConfig
  ): zio.aws.appsync.model.CachingConfig.ReadOnly = new Wrapper(impl)
}
