package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociateApiResponse(
    apiAssociation: Optional[zio.aws.appsync.model.ApiAssociation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.AssociateApiResponse = {
    import AssociateApiResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.AssociateApiResponse
      .builder()
      .optionallyWith(apiAssociation.map(value => value.buildAwsValue()))(
        _.apiAssociation
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.AssociateApiResponse.ReadOnly =
    zio.aws.appsync.model.AssociateApiResponse.wrap(buildAwsValue())
}
object AssociateApiResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.AssociateApiResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.AssociateApiResponse =
      zio.aws.appsync.model
        .AssociateApiResponse(apiAssociation.map(value => value.asEditable))
    def apiAssociation: Optional[zio.aws.appsync.model.ApiAssociation.ReadOnly]
    def getApiAssociation
        : ZIO[Any, AwsError, zio.aws.appsync.model.ApiAssociation.ReadOnly] =
      AwsError.unwrapOptionField("apiAssociation", apiAssociation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.AssociateApiResponse
  ) extends zio.aws.appsync.model.AssociateApiResponse.ReadOnly {
    override val apiAssociation
        : Optional[zio.aws.appsync.model.ApiAssociation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiAssociation())
        .map(value => zio.aws.appsync.model.ApiAssociation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.AssociateApiResponse
  ): zio.aws.appsync.model.AssociateApiResponse.ReadOnly = new Wrapper(impl)
}
