package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SourceApiAssociationConfig(
    mergeType: Optional[zio.aws.appsync.model.MergeType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.SourceApiAssociationConfig = {
    import SourceApiAssociationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.SourceApiAssociationConfig
      .builder()
      .optionallyWith(mergeType.map(value => value.unwrap))(_.mergeType)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.SourceApiAssociationConfig.ReadOnly =
    zio.aws.appsync.model.SourceApiAssociationConfig.wrap(buildAwsValue())
}
object SourceApiAssociationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.SourceApiAssociationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.SourceApiAssociationConfig =
      zio.aws.appsync.model
        .SourceApiAssociationConfig(mergeType.map(value => value))
    def mergeType: Optional[zio.aws.appsync.model.MergeType]
    def getMergeType: ZIO[Any, AwsError, zio.aws.appsync.model.MergeType] =
      AwsError.unwrapOptionField("mergeType", mergeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.SourceApiAssociationConfig
  ) extends zio.aws.appsync.model.SourceApiAssociationConfig.ReadOnly {
    override val mergeType: Optional[zio.aws.appsync.model.MergeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mergeType())
        .map(value => zio.aws.appsync.model.MergeType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.SourceApiAssociationConfig
  ): zio.aws.appsync.model.SourceApiAssociationConfig.ReadOnly = new Wrapper(
    impl
  )
}
