package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.{Context, Template}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class EvaluateMappingTemplateRequest(
    template: Template,
    context: Context
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.EvaluateMappingTemplateRequest = {
    import EvaluateMappingTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.EvaluateMappingTemplateRequest
      .builder()
      .template(Template.unwrap(template): java.lang.String)
      .context(Context.unwrap(context): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appsync.model.EvaluateMappingTemplateRequest.ReadOnly =
    zio.aws.appsync.model.EvaluateMappingTemplateRequest.wrap(buildAwsValue())
}
object EvaluateMappingTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.EvaluateMappingTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.EvaluateMappingTemplateRequest =
      zio.aws.appsync.model.EvaluateMappingTemplateRequest(template, context)
    def template: Template
    def context: Context
    def getTemplate: ZIO[Any, Nothing, Template] = ZIO.succeed(template)
    def getContext: ZIO[Any, Nothing, Context] = ZIO.succeed(context)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.EvaluateMappingTemplateRequest
  ) extends zio.aws.appsync.model.EvaluateMappingTemplateRequest.ReadOnly {
    override val template: Template =
      zio.aws.appsync.model.primitives.Template(impl.template())
    override val context: Context =
      zio.aws.appsync.model.primitives.Context(impl.context())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.EvaluateMappingTemplateRequest
  ): zio.aws.appsync.model.EvaluateMappingTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
