package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociateSourceGraphqlApiResponse(
    sourceApiAssociation: Optional[zio.aws.appsync.model.SourceApiAssociation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.AssociateSourceGraphqlApiResponse = {
    import AssociateSourceGraphqlApiResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.AssociateSourceGraphqlApiResponse
      .builder()
      .optionallyWith(sourceApiAssociation.map(value => value.buildAwsValue()))(
        _.sourceApiAssociation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appsync.model.AssociateSourceGraphqlApiResponse.ReadOnly =
    zio.aws.appsync.model.AssociateSourceGraphqlApiResponse
      .wrap(buildAwsValue())
}
object AssociateSourceGraphqlApiResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.AssociateSourceGraphqlApiResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.AssociateSourceGraphqlApiResponse =
      zio.aws.appsync.model.AssociateSourceGraphqlApiResponse(
        sourceApiAssociation.map(value => value.asEditable)
      )
    def sourceApiAssociation
        : Optional[zio.aws.appsync.model.SourceApiAssociation.ReadOnly]
    def getSourceApiAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.SourceApiAssociation.ReadOnly
    ] = AwsError.unwrapOptionField("sourceApiAssociation", sourceApiAssociation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.AssociateSourceGraphqlApiResponse
  ) extends zio.aws.appsync.model.AssociateSourceGraphqlApiResponse.ReadOnly {
    override val sourceApiAssociation
        : Optional[zio.aws.appsync.model.SourceApiAssociation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceApiAssociation())
        .map(value => zio.aws.appsync.model.SourceApiAssociation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.AssociateSourceGraphqlApiResponse
  ): zio.aws.appsync.model.AssociateSourceGraphqlApiResponse.ReadOnly =
    new Wrapper(impl)
}
