package zio.aws.appsync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.appsync.model.primitives.{
  Code,
  MaxBatchSize,
  MappingTemplate,
  ResourceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateFunctionRequest(
    apiId: String,
    name: ResourceName,
    description: Optional[String] = Optional.Absent,
    dataSourceName: ResourceName,
    requestMappingTemplate: Optional[MappingTemplate] = Optional.Absent,
    responseMappingTemplate: Optional[MappingTemplate] = Optional.Absent,
    functionVersion: Optional[String] = Optional.Absent,
    syncConfig: Optional[zio.aws.appsync.model.SyncConfig] = Optional.Absent,
    maxBatchSize: Optional[MaxBatchSize] = Optional.Absent,
    runtime: Optional[zio.aws.appsync.model.AppSyncRuntime] = Optional.Absent,
    code: Optional[Code] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CreateFunctionRequest = {
    import CreateFunctionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CreateFunctionRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .dataSourceName(ResourceName.unwrap(dataSourceName): java.lang.String)
      .optionallyWith(
        requestMappingTemplate.map(value =>
          MappingTemplate.unwrap(value): java.lang.String
        )
      )(_.requestMappingTemplate)
      .optionallyWith(
        responseMappingTemplate.map(value =>
          MappingTemplate.unwrap(value): java.lang.String
        )
      )(_.responseMappingTemplate)
      .optionallyWith(functionVersion.map(value => value: java.lang.String))(
        _.functionVersion
      )
      .optionallyWith(syncConfig.map(value => value.buildAwsValue()))(
        _.syncConfig
      )
      .optionallyWith(
        maxBatchSize.map(value => MaxBatchSize.unwrap(value): Integer)
      )(_.maxBatchSize)
      .optionallyWith(runtime.map(value => value.buildAwsValue()))(_.runtime)
      .optionallyWith(code.map(value => Code.unwrap(value): java.lang.String))(
        _.code
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CreateFunctionRequest.ReadOnly =
    zio.aws.appsync.model.CreateFunctionRequest.wrap(buildAwsValue())
}
object CreateFunctionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.CreateFunctionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CreateFunctionRequest =
      zio.aws.appsync.model.CreateFunctionRequest(
        apiId,
        name,
        description.map(value => value),
        dataSourceName,
        requestMappingTemplate.map(value => value),
        responseMappingTemplate.map(value => value),
        functionVersion.map(value => value),
        syncConfig.map(value => value.asEditable),
        maxBatchSize.map(value => value),
        runtime.map(value => value.asEditable),
        code.map(value => value)
      )
    def apiId: String
    def name: ResourceName
    def description: Optional[String]
    def dataSourceName: ResourceName
    def requestMappingTemplate: Optional[MappingTemplate]
    def responseMappingTemplate: Optional[MappingTemplate]
    def functionVersion: Optional[String]
    def syncConfig: Optional[zio.aws.appsync.model.SyncConfig.ReadOnly]
    def maxBatchSize: Optional[MaxBatchSize]
    def runtime: Optional[zio.aws.appsync.model.AppSyncRuntime.ReadOnly]
    def code: Optional[Code]
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDataSourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(dataSourceName)
    def getRequestMappingTemplate: ZIO[Any, AwsError, MappingTemplate] =
      AwsError.unwrapOptionField(
        "requestMappingTemplate",
        requestMappingTemplate
      )
    def getResponseMappingTemplate: ZIO[Any, AwsError, MappingTemplate] =
      AwsError.unwrapOptionField(
        "responseMappingTemplate",
        responseMappingTemplate
      )
    def getFunctionVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("functionVersion", functionVersion)
    def getSyncConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.SyncConfig.ReadOnly] =
      AwsError.unwrapOptionField("syncConfig", syncConfig)
    def getMaxBatchSize: ZIO[Any, AwsError, MaxBatchSize] =
      AwsError.unwrapOptionField("maxBatchSize", maxBatchSize)
    def getRuntime
        : ZIO[Any, AwsError, zio.aws.appsync.model.AppSyncRuntime.ReadOnly] =
      AwsError.unwrapOptionField("runtime", runtime)
    def getCode: ZIO[Any, AwsError, Code] =
      AwsError.unwrapOptionField("code", code)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CreateFunctionRequest
  ) extends zio.aws.appsync.model.CreateFunctionRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val name: ResourceName =
      zio.aws.appsync.model.primitives.ResourceName(impl.name())
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val dataSourceName: ResourceName =
      zio.aws.appsync.model.primitives.ResourceName(impl.dataSourceName())
    override val requestMappingTemplate: Optional[MappingTemplate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestMappingTemplate())
        .map(value => zio.aws.appsync.model.primitives.MappingTemplate(value))
    override val responseMappingTemplate: Optional[MappingTemplate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseMappingTemplate())
        .map(value => zio.aws.appsync.model.primitives.MappingTemplate(value))
    override val functionVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.functionVersion())
      .map(value => value: String)
    override val syncConfig
        : Optional[zio.aws.appsync.model.SyncConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.syncConfig())
        .map(value => zio.aws.appsync.model.SyncConfig.wrap(value))
    override val maxBatchSize: Optional[MaxBatchSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxBatchSize())
      .map(value => zio.aws.appsync.model.primitives.MaxBatchSize(value))
    override val runtime
        : Optional[zio.aws.appsync.model.AppSyncRuntime.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtime())
        .map(value => zio.aws.appsync.model.AppSyncRuntime.wrap(value))
    override val code: Optional[Code] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => zio.aws.appsync.model.primitives.Code(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CreateFunctionRequest
  ): zio.aws.appsync.model.CreateFunctionRequest.ReadOnly = new Wrapper(impl)
}
