package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateGraphqlApiRequest(
    apiId: String,
    name: String,
    logConfig: Optional[zio.aws.appsync.model.LogConfig] = Optional.Absent,
    authenticationType: Optional[zio.aws.appsync.model.AuthenticationType] =
      Optional.Absent,
    userPoolConfig: Optional[zio.aws.appsync.model.UserPoolConfig] =
      Optional.Absent,
    openIDConnectConfig: Optional[zio.aws.appsync.model.OpenIDConnectConfig] =
      Optional.Absent,
    additionalAuthenticationProviders: Optional[
      Iterable[zio.aws.appsync.model.AdditionalAuthenticationProvider]
    ] = Optional.Absent,
    xrayEnabled: Optional[Boolean] = Optional.Absent,
    lambdaAuthorizerConfig: Optional[
      zio.aws.appsync.model.LambdaAuthorizerConfig
    ] = Optional.Absent,
    mergedApiExecutionRoleArn: Optional[String] = Optional.Absent,
    ownerContact: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiRequest = {
    import UpdateGraphqlApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .name(name: java.lang.String)
      .optionallyWith(logConfig.map(value => value.buildAwsValue()))(
        _.logConfig
      )
      .optionallyWith(authenticationType.map(value => value.unwrap))(
        _.authenticationType
      )
      .optionallyWith(userPoolConfig.map(value => value.buildAwsValue()))(
        _.userPoolConfig
      )
      .optionallyWith(openIDConnectConfig.map(value => value.buildAwsValue()))(
        _.openIDConnectConfig
      )
      .optionallyWith(
        additionalAuthenticationProviders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalAuthenticationProviders)
      .optionallyWith(xrayEnabled.map(value => value: java.lang.Boolean))(
        _.xrayEnabled
      )
      .optionallyWith(
        lambdaAuthorizerConfig.map(value => value.buildAwsValue())
      )(_.lambdaAuthorizerConfig)
      .optionallyWith(
        mergedApiExecutionRoleArn.map(value => value: java.lang.String)
      )(_.mergedApiExecutionRoleArn)
      .optionallyWith(ownerContact.map(value => value: java.lang.String))(
        _.ownerContact
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.UpdateGraphqlApiRequest.ReadOnly =
    zio.aws.appsync.model.UpdateGraphqlApiRequest.wrap(buildAwsValue())
}
object UpdateGraphqlApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.UpdateGraphqlApiRequest =
      zio.aws.appsync.model.UpdateGraphqlApiRequest(
        apiId,
        name,
        logConfig.map(value => value.asEditable),
        authenticationType.map(value => value),
        userPoolConfig.map(value => value.asEditable),
        openIDConnectConfig.map(value => value.asEditable),
        additionalAuthenticationProviders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        xrayEnabled.map(value => value),
        lambdaAuthorizerConfig.map(value => value.asEditable),
        mergedApiExecutionRoleArn.map(value => value),
        ownerContact.map(value => value)
      )
    def apiId: String
    def name: String
    def logConfig: Optional[zio.aws.appsync.model.LogConfig.ReadOnly]
    def authenticationType: Optional[zio.aws.appsync.model.AuthenticationType]
    def userPoolConfig: Optional[zio.aws.appsync.model.UserPoolConfig.ReadOnly]
    def openIDConnectConfig
        : Optional[zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly]
    def additionalAuthenticationProviders: Optional[
      List[zio.aws.appsync.model.AdditionalAuthenticationProvider.ReadOnly]
    ]
    def xrayEnabled: Optional[Boolean]
    def lambdaAuthorizerConfig
        : Optional[zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly]
    def mergedApiExecutionRoleArn: Optional[String]
    def ownerContact: Optional[String]
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getLogConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.LogConfig.ReadOnly] =
      AwsError.unwrapOptionField("logConfig", logConfig)
    def getAuthenticationType
        : ZIO[Any, AwsError, zio.aws.appsync.model.AuthenticationType] =
      AwsError.unwrapOptionField("authenticationType", authenticationType)
    def getUserPoolConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.UserPoolConfig.ReadOnly] =
      AwsError.unwrapOptionField("userPoolConfig", userPoolConfig)
    def getOpenIDConnectConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly
    ] = AwsError.unwrapOptionField("openIDConnectConfig", openIDConnectConfig)
    def getAdditionalAuthenticationProviders: ZIO[Any, AwsError, List[
      zio.aws.appsync.model.AdditionalAuthenticationProvider.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "additionalAuthenticationProviders",
      additionalAuthenticationProviders
    )
    def getXrayEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("xrayEnabled", xrayEnabled)
    def getLambdaAuthorizerConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaAuthorizerConfig",
      lambdaAuthorizerConfig
    )
    def getMergedApiExecutionRoleArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("mergedApiExecutionRoleArn", mergedApiExecutionRoleArn)
    def getOwnerContact: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerContact", ownerContact)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiRequest
  ) extends zio.aws.appsync.model.UpdateGraphqlApiRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val name: String = impl.name(): String
    override val logConfig: Optional[zio.aws.appsync.model.LogConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logConfig())
        .map(value => zio.aws.appsync.model.LogConfig.wrap(value))
    override val authenticationType
        : Optional[zio.aws.appsync.model.AuthenticationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationType())
        .map(value => zio.aws.appsync.model.AuthenticationType.wrap(value))
    override val userPoolConfig
        : Optional[zio.aws.appsync.model.UserPoolConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userPoolConfig())
        .map(value => zio.aws.appsync.model.UserPoolConfig.wrap(value))
    override val openIDConnectConfig
        : Optional[zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.openIDConnectConfig())
        .map(value => zio.aws.appsync.model.OpenIDConnectConfig.wrap(value))
    override val additionalAuthenticationProviders: Optional[
      List[zio.aws.appsync.model.AdditionalAuthenticationProvider.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalAuthenticationProviders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appsync.model.AdditionalAuthenticationProvider.wrap(item)
        }.toList
      )
    override val xrayEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.xrayEnabled())
      .map(value => value: Boolean)
    override val lambdaAuthorizerConfig
        : Optional[zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambdaAuthorizerConfig())
        .map(value => zio.aws.appsync.model.LambdaAuthorizerConfig.wrap(value))
    override val mergedApiExecutionRoleArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mergedApiExecutionRoleArn())
        .map(value => value: String)
    override val ownerContact: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerContact())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiRequest
  ): zio.aws.appsync.model.UpdateGraphqlApiRequest.ReadOnly = new Wrapper(impl)
}
