package zio.aws.appsync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.appsync.model.primitives.{
  Code,
  MaxBatchSize,
  MappingTemplate,
  ResourceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateResolverRequest(
    apiId: String,
    typeName: ResourceName,
    fieldName: ResourceName,
    dataSourceName: Optional[ResourceName] = Optional.Absent,
    requestMappingTemplate: Optional[MappingTemplate] = Optional.Absent,
    responseMappingTemplate: Optional[MappingTemplate] = Optional.Absent,
    kind: Optional[zio.aws.appsync.model.ResolverKind] = Optional.Absent,
    pipelineConfig: Optional[zio.aws.appsync.model.PipelineConfig] =
      Optional.Absent,
    syncConfig: Optional[zio.aws.appsync.model.SyncConfig] = Optional.Absent,
    cachingConfig: Optional[zio.aws.appsync.model.CachingConfig] =
      Optional.Absent,
    maxBatchSize: Optional[MaxBatchSize] = Optional.Absent,
    runtime: Optional[zio.aws.appsync.model.AppSyncRuntime] = Optional.Absent,
    code: Optional[Code] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CreateResolverRequest = {
    import CreateResolverRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CreateResolverRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .typeName(ResourceName.unwrap(typeName): java.lang.String)
      .fieldName(ResourceName.unwrap(fieldName): java.lang.String)
      .optionallyWith(
        dataSourceName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.dataSourceName)
      .optionallyWith(
        requestMappingTemplate.map(value =>
          MappingTemplate.unwrap(value): java.lang.String
        )
      )(_.requestMappingTemplate)
      .optionallyWith(
        responseMappingTemplate.map(value =>
          MappingTemplate.unwrap(value): java.lang.String
        )
      )(_.responseMappingTemplate)
      .optionallyWith(kind.map(value => value.unwrap))(_.kind)
      .optionallyWith(pipelineConfig.map(value => value.buildAwsValue()))(
        _.pipelineConfig
      )
      .optionallyWith(syncConfig.map(value => value.buildAwsValue()))(
        _.syncConfig
      )
      .optionallyWith(cachingConfig.map(value => value.buildAwsValue()))(
        _.cachingConfig
      )
      .optionallyWith(
        maxBatchSize.map(value => MaxBatchSize.unwrap(value): Integer)
      )(_.maxBatchSize)
      .optionallyWith(runtime.map(value => value.buildAwsValue()))(_.runtime)
      .optionallyWith(code.map(value => Code.unwrap(value): java.lang.String))(
        _.code
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CreateResolverRequest.ReadOnly =
    zio.aws.appsync.model.CreateResolverRequest.wrap(buildAwsValue())
}
object CreateResolverRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.CreateResolverRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CreateResolverRequest =
      zio.aws.appsync.model.CreateResolverRequest(
        apiId,
        typeName,
        fieldName,
        dataSourceName.map(value => value),
        requestMappingTemplate.map(value => value),
        responseMappingTemplate.map(value => value),
        kind.map(value => value),
        pipelineConfig.map(value => value.asEditable),
        syncConfig.map(value => value.asEditable),
        cachingConfig.map(value => value.asEditable),
        maxBatchSize.map(value => value),
        runtime.map(value => value.asEditable),
        code.map(value => value)
      )
    def apiId: String
    def typeName: ResourceName
    def fieldName: ResourceName
    def dataSourceName: Optional[ResourceName]
    def requestMappingTemplate: Optional[MappingTemplate]
    def responseMappingTemplate: Optional[MappingTemplate]
    def kind: Optional[zio.aws.appsync.model.ResolverKind]
    def pipelineConfig: Optional[zio.aws.appsync.model.PipelineConfig.ReadOnly]
    def syncConfig: Optional[zio.aws.appsync.model.SyncConfig.ReadOnly]
    def cachingConfig: Optional[zio.aws.appsync.model.CachingConfig.ReadOnly]
    def maxBatchSize: Optional[MaxBatchSize]
    def runtime: Optional[zio.aws.appsync.model.AppSyncRuntime.ReadOnly]
    def code: Optional[Code]
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getTypeName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(typeName)
    def getFieldName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(fieldName)
    def getDataSourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("dataSourceName", dataSourceName)
    def getRequestMappingTemplate: ZIO[Any, AwsError, MappingTemplate] =
      AwsError.unwrapOptionField(
        "requestMappingTemplate",
        requestMappingTemplate
      )
    def getResponseMappingTemplate: ZIO[Any, AwsError, MappingTemplate] =
      AwsError.unwrapOptionField(
        "responseMappingTemplate",
        responseMappingTemplate
      )
    def getKind: ZIO[Any, AwsError, zio.aws.appsync.model.ResolverKind] =
      AwsError.unwrapOptionField("kind", kind)
    def getPipelineConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.PipelineConfig.ReadOnly] =
      AwsError.unwrapOptionField("pipelineConfig", pipelineConfig)
    def getSyncConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.SyncConfig.ReadOnly] =
      AwsError.unwrapOptionField("syncConfig", syncConfig)
    def getCachingConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.CachingConfig.ReadOnly] =
      AwsError.unwrapOptionField("cachingConfig", cachingConfig)
    def getMaxBatchSize: ZIO[Any, AwsError, MaxBatchSize] =
      AwsError.unwrapOptionField("maxBatchSize", maxBatchSize)
    def getRuntime
        : ZIO[Any, AwsError, zio.aws.appsync.model.AppSyncRuntime.ReadOnly] =
      AwsError.unwrapOptionField("runtime", runtime)
    def getCode: ZIO[Any, AwsError, Code] =
      AwsError.unwrapOptionField("code", code)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CreateResolverRequest
  ) extends zio.aws.appsync.model.CreateResolverRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val typeName: ResourceName =
      zio.aws.appsync.model.primitives.ResourceName(impl.typeName())
    override val fieldName: ResourceName =
      zio.aws.appsync.model.primitives.ResourceName(impl.fieldName())
    override val dataSourceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSourceName())
      .map(value => zio.aws.appsync.model.primitives.ResourceName(value))
    override val requestMappingTemplate: Optional[MappingTemplate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requestMappingTemplate())
        .map(value => zio.aws.appsync.model.primitives.MappingTemplate(value))
    override val responseMappingTemplate: Optional[MappingTemplate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseMappingTemplate())
        .map(value => zio.aws.appsync.model.primitives.MappingTemplate(value))
    override val kind: Optional[zio.aws.appsync.model.ResolverKind] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kind())
        .map(value => zio.aws.appsync.model.ResolverKind.wrap(value))
    override val pipelineConfig
        : Optional[zio.aws.appsync.model.PipelineConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineConfig())
        .map(value => zio.aws.appsync.model.PipelineConfig.wrap(value))
    override val syncConfig
        : Optional[zio.aws.appsync.model.SyncConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.syncConfig())
        .map(value => zio.aws.appsync.model.SyncConfig.wrap(value))
    override val cachingConfig
        : Optional[zio.aws.appsync.model.CachingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cachingConfig())
        .map(value => zio.aws.appsync.model.CachingConfig.wrap(value))
    override val maxBatchSize: Optional[MaxBatchSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxBatchSize())
      .map(value => zio.aws.appsync.model.primitives.MaxBatchSize(value))
    override val runtime
        : Optional[zio.aws.appsync.model.AppSyncRuntime.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtime())
        .map(value => zio.aws.appsync.model.AppSyncRuntime.wrap(value))
    override val code: Optional[Code] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => zio.aws.appsync.model.primitives.Code(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CreateResolverRequest
  ): zio.aws.appsync.model.CreateResolverRequest.ReadOnly = new Wrapper(impl)
}
