package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateGraphqlApiRequest(
    name: String,
    logConfig: Optional[zio.aws.appsync.model.LogConfig] = Optional.Absent,
    authenticationType: zio.aws.appsync.model.AuthenticationType,
    userPoolConfig: Optional[zio.aws.appsync.model.UserPoolConfig] =
      Optional.Absent,
    openIDConnectConfig: Optional[zio.aws.appsync.model.OpenIDConnectConfig] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    additionalAuthenticationProviders: Optional[
      Iterable[zio.aws.appsync.model.AdditionalAuthenticationProvider]
    ] = Optional.Absent,
    xrayEnabled: Optional[Boolean] = Optional.Absent,
    lambdaAuthorizerConfig: Optional[
      zio.aws.appsync.model.LambdaAuthorizerConfig
    ] = Optional.Absent,
    visibility: Optional[zio.aws.appsync.model.GraphQLApiVisibility] =
      Optional.Absent,
    apiType: Optional[zio.aws.appsync.model.GraphQLApiType] = Optional.Absent,
    mergedApiExecutionRoleArn: Optional[String] = Optional.Absent,
    ownerContact: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CreateGraphqlApiRequest = {
    import CreateGraphqlApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CreateGraphqlApiRequest
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(logConfig.map(value => value.buildAwsValue()))(
        _.logConfig
      )
      .authenticationType(authenticationType.unwrap)
      .optionallyWith(userPoolConfig.map(value => value.buildAwsValue()))(
        _.userPoolConfig
      )
      .optionallyWith(openIDConnectConfig.map(value => value.buildAwsValue()))(
        _.openIDConnectConfig
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        additionalAuthenticationProviders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalAuthenticationProviders)
      .optionallyWith(xrayEnabled.map(value => value: java.lang.Boolean))(
        _.xrayEnabled
      )
      .optionallyWith(
        lambdaAuthorizerConfig.map(value => value.buildAwsValue())
      )(_.lambdaAuthorizerConfig)
      .optionallyWith(visibility.map(value => value.unwrap))(_.visibility)
      .optionallyWith(apiType.map(value => value.unwrap))(_.apiType)
      .optionallyWith(
        mergedApiExecutionRoleArn.map(value => value: java.lang.String)
      )(_.mergedApiExecutionRoleArn)
      .optionallyWith(ownerContact.map(value => value: java.lang.String))(
        _.ownerContact
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CreateGraphqlApiRequest.ReadOnly =
    zio.aws.appsync.model.CreateGraphqlApiRequest.wrap(buildAwsValue())
}
object CreateGraphqlApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.CreateGraphqlApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CreateGraphqlApiRequest =
      zio.aws.appsync.model.CreateGraphqlApiRequest(
        name,
        logConfig.map(value => value.asEditable),
        authenticationType,
        userPoolConfig.map(value => value.asEditable),
        openIDConnectConfig.map(value => value.asEditable),
        tags.map(value => value),
        additionalAuthenticationProviders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        xrayEnabled.map(value => value),
        lambdaAuthorizerConfig.map(value => value.asEditable),
        visibility.map(value => value),
        apiType.map(value => value),
        mergedApiExecutionRoleArn.map(value => value),
        ownerContact.map(value => value)
      )
    def name: String
    def logConfig: Optional[zio.aws.appsync.model.LogConfig.ReadOnly]
    def authenticationType: zio.aws.appsync.model.AuthenticationType
    def userPoolConfig: Optional[zio.aws.appsync.model.UserPoolConfig.ReadOnly]
    def openIDConnectConfig
        : Optional[zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def additionalAuthenticationProviders: Optional[
      List[zio.aws.appsync.model.AdditionalAuthenticationProvider.ReadOnly]
    ]
    def xrayEnabled: Optional[Boolean]
    def lambdaAuthorizerConfig
        : Optional[zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly]
    def visibility: Optional[zio.aws.appsync.model.GraphQLApiVisibility]
    def apiType: Optional[zio.aws.appsync.model.GraphQLApiType]
    def mergedApiExecutionRoleArn: Optional[String]
    def ownerContact: Optional[String]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getLogConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.LogConfig.ReadOnly] =
      AwsError.unwrapOptionField("logConfig", logConfig)
    def getAuthenticationType
        : ZIO[Any, Nothing, zio.aws.appsync.model.AuthenticationType] =
      ZIO.succeed(authenticationType)
    def getUserPoolConfig
        : ZIO[Any, AwsError, zio.aws.appsync.model.UserPoolConfig.ReadOnly] =
      AwsError.unwrapOptionField("userPoolConfig", userPoolConfig)
    def getOpenIDConnectConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly
    ] = AwsError.unwrapOptionField("openIDConnectConfig", openIDConnectConfig)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getAdditionalAuthenticationProviders: ZIO[Any, AwsError, List[
      zio.aws.appsync.model.AdditionalAuthenticationProvider.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "additionalAuthenticationProviders",
      additionalAuthenticationProviders
    )
    def getXrayEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("xrayEnabled", xrayEnabled)
    def getLambdaAuthorizerConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaAuthorizerConfig",
      lambdaAuthorizerConfig
    )
    def getVisibility
        : ZIO[Any, AwsError, zio.aws.appsync.model.GraphQLApiVisibility] =
      AwsError.unwrapOptionField("visibility", visibility)
    def getApiType: ZIO[Any, AwsError, zio.aws.appsync.model.GraphQLApiType] =
      AwsError.unwrapOptionField("apiType", apiType)
    def getMergedApiExecutionRoleArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("mergedApiExecutionRoleArn", mergedApiExecutionRoleArn)
    def getOwnerContact: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerContact", ownerContact)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CreateGraphqlApiRequest
  ) extends zio.aws.appsync.model.CreateGraphqlApiRequest.ReadOnly {
    override val name: String = impl.name(): String
    override val logConfig: Optional[zio.aws.appsync.model.LogConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logConfig())
        .map(value => zio.aws.appsync.model.LogConfig.wrap(value))
    override val authenticationType: zio.aws.appsync.model.AuthenticationType =
      zio.aws.appsync.model.AuthenticationType.wrap(impl.authenticationType())
    override val userPoolConfig
        : Optional[zio.aws.appsync.model.UserPoolConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userPoolConfig())
        .map(value => zio.aws.appsync.model.UserPoolConfig.wrap(value))
    override val openIDConnectConfig
        : Optional[zio.aws.appsync.model.OpenIDConnectConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.openIDConnectConfig())
        .map(value => zio.aws.appsync.model.OpenIDConnectConfig.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appsync.model.primitives
              .TagKey(key) -> zio.aws.appsync.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val additionalAuthenticationProviders: Optional[
      List[zio.aws.appsync.model.AdditionalAuthenticationProvider.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalAuthenticationProviders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appsync.model.AdditionalAuthenticationProvider.wrap(item)
        }.toList
      )
    override val xrayEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.xrayEnabled())
      .map(value => value: Boolean)
    override val lambdaAuthorizerConfig
        : Optional[zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambdaAuthorizerConfig())
        .map(value => zio.aws.appsync.model.LambdaAuthorizerConfig.wrap(value))
    override val visibility
        : Optional[zio.aws.appsync.model.GraphQLApiVisibility] =
      zio.aws.core.internal
        .optionalFromNullable(impl.visibility())
        .map(value => zio.aws.appsync.model.GraphQLApiVisibility.wrap(value))
    override val apiType: Optional[zio.aws.appsync.model.GraphQLApiType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiType())
        .map(value => zio.aws.appsync.model.GraphQLApiType.wrap(value))
    override val mergedApiExecutionRoleArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mergedApiExecutionRoleArn())
        .map(value => value: String)
    override val ownerContact: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerContact())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CreateGraphqlApiRequest
  ): zio.aws.appsync.model.CreateGraphqlApiRequest.ReadOnly = new Wrapper(impl)
}
